<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2014 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

\defined('_JEXEC') or die();

use Joomla\CMS\HTML\HTMLHelper;

$document->loadStyleFile('default.css', 'mod_dpcalendar_map');
$document->loadScriptFile('views/map/default.js');
$document->addStyle($params->get('custom_css', ''));

$layoutHelper->renderLayout('block.map', $displayData);

$translator->translateJS('COM_DPCALENDAR_FIELD_CONFIG_EVENT_LABEL_NO_EVENT_TEXT');
?>
<div class="mod-dpcalendar-map mod-dpcalendar-map-<?php echo $module->id; ?> dp-search-map"
	data-popup="<?php echo $params->get('show_as_popup'); ?>">
	<div class="mod-dpcalendar-map__custom-text">
		<?php echo HTMLHelper::_('content.prepare', $translator->translate($params->get('textbefore', ''))); ?>
	</div>
	<?php echo $layoutHelper->renderLayout('block.loader', $displayData); ?>
	<?php echo $layoutHelper->renderLayout('block.filter', $displayData); ?>
	<div class="mod-dpcalendar-map__map dp-map"
		style="width: <?php echo $params->get('width', '100%'); ?>; height: <?php echo $params->get('height', '300px'); ?>"
		data-zoom="<?php echo $params->get('zoom', 4); ?>"
		data-latitude="<?php echo $params->get('lat', 47); ?>"
		data-longitude="<?php echo $params->get('long', 4); ?>"
		data-ask-consent="<?php echo $params->get('map_ask_consent'); ?>">
	</div>
	<div class="mod-dpcalendar-map__custom-text">
		<?php echo HTMLHelper::_('content.prepare', $translator->translate($params->get('textafter', ''))); ?>
	</div>
</div>
