<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2018 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Component\DPCalendar\Administrator\HTML\Block;

\defined('_JEXEC') or die();

/**
 * Icon constants
 */
class Icon
{
	/**
	 * The back icon.
	 *
	 * @var string
	 */
	public const BACK = 'angle-left';

	/**
	 * The book icon.
	 *
	 * @var string
	 */
	public const BOOK = 'ticket';

	/**
	 * The bullseye icon.
	 *
	 * @var string
	 */
	public const BULLSEYE = 'bullseye';

	/**
	 * The calendar icon.
	 *
	 * @var string
	 */
	public const CALENDAR = 'calendar-days';

	/**
	 * The cancel icon.
	 *
	 * @var string
	 */
	public const CANCEL = 'ban';

	/**
	 * The certificate icon.
	 *
	 * @var string
	 */
	public const CERTIFICATE = 'certificate';

	/**
	 * The clock icon.
	 *
	 * @var string
	 */
	public const CLOCK = 'clock';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	public const COG = 'gear';

	/**
	 * The compress icon.
	 *
	 * @var string
	 */
	public const COMPRESS = 'down-left-and-up-right-to-center';

	/**
	 * The directions icon.
	 *
	 * @var string
	 */
	public const DATABASE = 'database';

	/**
	 * The delete icon.
	 *
	 * @var string
	 */
	public const DELETE = 'trash';

	/**
	 * The directions icon.
	 *
	 * @var string
	 */
	public const DIRECTIONS = 'directions';

	/**
	 * The down icon.
	 *
	 * @var string
	 */
	public const DOWN = 'caret-down';

	/**
	 * The download icon.
	 *
	 * @var string
	 */
	public const DOWNLOAD = 'download';

	/**
	 * The edit icon.
	 *
	 * @var string
	 */
	public const EDIT = 'pencil';

	/**
	 * The exclamation icon.
	 *
	 * @var string
	 */
	public const EXCLAMATION = 'exclamation';

	/**
	 * The external link icon.
	 *
	 * @var string
	 */
	public const EXTERNAL = 'square-up-right';

	/**
	 * The expand icon.
	 *
	 * @var string
	 */
	public const EXPAND = 'up-right-and-down-left-from-center';

	/**
	 * The file icon.
	 *
	 * @var string
	 */
	public const FILE = 'file';

	/**
	 * The filter icon.
	 *
	 * @var string
	 */
	public const FILTER = 'filter';

	/**
	 * The invoice icon.
	 *
	 * @var string
	 */
	public const INVOICE = 'file-invoice';

	/**
	 * The info icon.
	 *
	 * @var string
	 */
	public const INFO = 'circle-info';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	public const LANGUAGE = 'globe';

	/**
	 * The list icon.
	 *
	 * @var string
	 */
	public const LISTING = 'list';

	/**
	 * The location icon.
	 *
	 * @var string
	 */
	public const LOCATION = 'location-dot';

	/**
	 * The lock icon.
	 *
	 * @var string
	 */
	public const LOCK = 'lock';

	/**
	 * The mail icon.
	 *
	 * @var string
	 */
	public const MAIL = 'envelope';

	/**
	 * The map icon.
	 *
	 * @var string
	 */
	public const MAP = 'map-location-dot';

	/**
	 * The money icon.
	 *
	 * @var string
	 */
	public const MONEY = 'money-bill-1';

	/**
	 * The multiple item icon.
	 *
	 * @var string
	 */
	public const MULTIPLE = 'clone';

	/**
	 * The next icon.
	 *
	 * @var string
	 */
	public const NEXT = 'angle-right';

	/**
	 * The ok icon.
	 *
	 * @var string
	 */
	public const OK = 'check';

	/**
	 * The plus icon.
	 *
	 * @var string
	 */
	public const PLUS = 'plus';

	/**
	 * The edit icon.
	 *
	 * @var string
	 */
	public const PRINTING = 'print';

	/**
	 * The receipt icon.
	 *
	 * @var string
	 */
	public const RECEIPT = 'receipt';

	/**
	 * The recurring icon.
	 *
	 * @var string
	 */
	public const RECURRING = 'arrow-rotate-right';

	/**
	 * The search icon.
	 *
	 * @var string
	 */
	public const SEARCH = 'magnifying-glass';

	/**
	 * The signup icon.
	 *
	 * @var string
	 */
	public const SIGNUP = 'right-to-bracket';

	/**
	 * The single item icon.
	 *
	 * @var string
	 */
	public const SINGLE = 'square';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	public const SYNC = 'arrows-rotate';

	/**
	 * The up icon.
	 *
	 * @var string
	 */
	public const UP = 'caret-up';

	/**
	 * The users icon.
	 *
	 * @var string
	 */
	public const USERS = 'users';

	/**
	 * The icon cache, used by the layout.
	 *
	 * @var array
	 */
	public static $pathCache = [];
}
