<?php

/*
 * This file is part of Mustache.php.
 *
 * (c) 2010-2025 Justin Hileman
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Mustache;

use Psr\Log\LoggerInterface;

/**
 * Mustache Cache interface.
 *
 * Interface for caching and loading Template classes generated by the Compiler.
 */
interface Cache
{
    /**
     * Load a compiled Template class from cache.
     *
     * @param string $key
     *
     * @return bool indicates successfully class load
     */
    public function load($key);

    /**
     * Cache and load a compiled Template class.
     *
     * @param string $key
     * @param string $value
     */
    public function cache($key, $value);

    /**
     * Set a logger instance.
     *
     * @param Logger|LoggerInterface $logger
     */
    public function setLogger($logger = null);
}
