<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2014 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Module\Mini\Site\Dispatcher;

\defined('_JEXEC') or die();

use DigitalPeak\Component\DPCalendar\Administrator\Helper\DateHelper;
use DigitalPeak\Component\DPCalendar\Administrator\Helper\DPCalendarHelper;
use DigitalPeak\Component\DPCalendar\Administrator\HTML\Document\HtmlDocument;
use DigitalPeak\Component\DPCalendar\Administrator\Router\Router;
use DigitalPeak\Component\DPCalendar\Administrator\Translator\Translator;
use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\Registry\Registry;

class Dispatcher extends AbstractModuleDispatcher
{
	protected function getLayoutData(): false|array
	{
		$data = parent::getLayoutData();
		if ($data === false) {
			return $data;
		}

		/** @var CMSApplicationInterface $app */
		$app = $data['app'];

		/** @var Registry $params */
		$params = $data['params'];

		// Helpers
		$document   = new HtmlDocument();
		$translator = new Translator();
		$dateHelper = new DateHelper();
		$dateHelper->setTranslator($translator);

		$layoutHelper = $app->bootComponent('dpcalendar')->getMVCFactory()->createModel('Layout', 'Administrator');
		$router       = new Router();

		$cParams      = clone ComponentHelper::getParams('com_dpcalendar');
		$moduleParams = $cParams->merge($params);

		// The display data
		$data = array_merge($data, [
			'document'     => $document,
			'layoutHelper' => $layoutHelper,
			'dateHelper'   => $dateHelper,
			'translator'   => $translator,
			'router'       => $router,
			'input'        => $app->getInput(),
			'params'       => $moduleParams,
			'moduleParams' => $moduleParams,
		]);

		$app->getLanguage()->load('com_dpcalendar', JPATH_ADMINISTRATOR . '/components/com_dpcalendar');
		$app->getLanguage()->load('com_dpcalendar', JPATH_SITE . '/components/com_dpcalendar');

		$model = $app->bootComponent('dpcalendar')->getMVCFactory()->createModel('Calendar', 'Site', ['ignore_request' => true]);
		$model->getState();
		$model->setState('filter.parentIds', $moduleParams->get('ids', ['root']));

		$ids = [];
		foreach ($model->getItems() as $calendar) {
			$ids[] = $calendar->getId();
		}

		if ($ids === []) {
			return $data;
		}

		$resources = [];
		if ($params->get('calendar_filter_locations') && $params->get('calendar_resource_views') && !DPCalendarHelper::isFree()) {
			// Load the model
			$locationModel = $app->bootComponent('dpcalendar')->getMVCFactory()->createModel('Locations', 'Administrator', ['ignore_request' => true]);
			$locationModel->getState();
			$locationModel->setState('list.limit', 10000);
			$locationModel->setState('filter.search', 'ids:' . implode(',', $params->get('calendar_filter_locations')));

			// Add the locations
			foreach ($locationModel->getItems() as $location) {
				if ($location->rooms) {
					foreach ($location->rooms as $room) {
						$resources[] = (object)['id' => $location->id . '-' . $room->id, 'title' => $room->title];
					}
				}
			}
		}

		$quickaddForm = $model->getQuickAddForm($params);
		$quickaddForm->setValue('catid', null, $ids[0]);

		$data['ids']          = $ids;
		$data['quickaddForm'] = $quickaddForm;
		$data['resources']    = $resources;
		$data['displayData']  = $data;

		return $data;
	}
}
