<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2014 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Module\Map\Site\Dispatcher;

\defined('_JEXEC') or die();

use DigitalPeak\Component\DPCalendar\Administrator\Extension\DPCalendarComponent;
use DigitalPeak\Component\DPCalendar\Administrator\Helper\DateHelper;
use DigitalPeak\Component\DPCalendar\Administrator\HTML\Document\HtmlDocument;
use DigitalPeak\Component\DPCalendar\Administrator\Router\Router;
use DigitalPeak\Component\DPCalendar\Administrator\Translator\Translator;
use DigitalPeak\Component\DPCalendar\Site\Model\EventsModel;
use DigitalPeak\Component\DPCalendar\Site\View\CalendarViewTrait;
use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Form\Form;
use Joomla\CMS\User\CurrentUserTrait;
use Joomla\Registry\Registry;

class Dispatcher extends AbstractModuleDispatcher
{
	use CalendarViewTrait;
	use CurrentUserTrait;

	public Form $filterForm;

	public array $activeFilters;

	protected Registry $params;

	protected EventsModel $model;

	/** @var Registry $state */
	protected $state;

	protected function getLayoutData()
	{
		$data = parent::getLayoutData();
		if ($data === false) {
			return $data;
		}

		$app = $data['app'];
		if (!$app instanceof CMSWebApplicationInterface) {
			return $data;
		}

		if ($user = $app->getIdentity()) {
			$this->setCurrentUser($user);
		}

		$this->model = $this->getDPCalendar()->getMVCFactory()->createModel('Events', 'Site', ['name' => 'map.module.' . $data['module']->id]);
		$this->model->getState();

		/** @var Registry $params */
		$params = $data['params'];

		// Helpers
		$document   = new HtmlDocument();
		$translator = new Translator();
		$dateHelper = new DateHelper();
		$dateHelper->setTranslator($translator);

		$layoutHelper = $this->getDPCalendar()->getMVCFactory()->createModel('Layout', 'Administrator');
		$router       = new Router();

		$cParams = clone ComponentHelper::getParams('com_dpcalendar');
		$cParams->set('textbefore', '');
		$cParams->set('textafter', '');

		$moduleParams = $cParams->merge($params);
		$this->params = $moduleParams;

		// The display data
		$data = array_merge($data, [
			'document'     => $document,
			'layoutHelper' => $layoutHelper,
			'dateHelper'   => $dateHelper,
			'translator'   => $translator,
			'router'       => $router,
			'input'        => $app->getInput(),
			'params'       => $moduleParams,
			'format'       => $params->get('date_format', 'd.m.Y')
		]);

		$app->getLanguage()->load('com_dpcalendar', JPATH_ADMINISTRATOR . '/components/com_dpcalendar');
		$app->getLanguage()->load('com_dpcalendar', JPATH_SITE . '/components/com_dpcalendar');

		// Get the calendars and their children
		$calendarModel = $this->getDPCalendar()->getMVCFactory()->createModel('Calendar', 'Site');
		$calendarModel->getState();
		$calendarModel->setState('filter.parentIds', $params->get('ids', '-1'));

		// The calendar ids
		$data['calendars'] = $calendarModel->getItems();
		foreach ($data['calendars'] as $calendar) {
			$this->fillCalendar($calendar);
		}

		Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_dpcalendar/forms');
		$this->state = $this->model->getState();

		$this->activeFilters = [];

		$moduleParams->set('form_state', $moduleParams->get('map_filter_form', 2));
		$moduleParams->set('map_module_filter_form_hidden_fields', $moduleParams->get('map_filter_form_hidden_fields', []));
		$moduleParams->set('map_module_filter_radius', $moduleParams->get('radius', 20));
		$moduleParams->set('map_module_filter_length_type', $moduleParams->get('length-type', 'm'));
		$moduleParams->set('map_module_filter_tags', $moduleParams->get('map_filter_tags', 'm'));
		$moduleParams->set('event_form_date_format', $moduleParams->get('date_format', 'd.m.Y'));

		$this->prepareForm($data['calendars']);

		$this->filterForm->setFieldAttribute('start-date', 'formatted', true, 'list');
		$this->filterForm->setFieldAttribute('end-date', 'formatted', true, 'list');

		if (!$this->filterForm->getValue('start-date', 'list')) {
			$this->filterForm->setValue('start-date', 'list', $params->get('start_date'));
			$this->filterForm->setFieldAttribute('start-date', 'formatted', false, 'list');
		}

		if (!$this->filterForm->getValue('end-date', 'list')) {
			$this->filterForm->setValue('end-date', 'list', $params->get('end_date'));
			$this->filterForm->setFieldAttribute('end-date', 'formatted', false, 'list');
		}

		if (!$this->filterForm->getValue('radius', 'filter')) {
			$this->filterForm->setValue('radius', 'filter', $params->get('radius', 20));
		}

		if (!$this->filterForm->getValue('length-type', 'filter')) {
			$this->filterForm->setValue('length-type', 'filter', $params->get('length-type', 'm'));
		}

		$this->params->set('hidden_fields', $this->params->get('map_filter_form_hidden_fields', []));

		$data['form']   = $this->filterForm;
		$data['user']   = $app->getIdentity();
		$data['action'] = 'index.php?option=com_dpcalendar&view=map&layout=events&format=raw&module_id=' . $this->module->id;

		$data['displayData'] = $data;

		return $data;
	}

	protected function getName(): string
	{
		return 'map_module';
	}

	protected function getDPCalendar(): DPCalendarComponent
	{
		return $this->app->bootComponent('dpcalendar');
	}

	protected function getModel(): ?EventsModel
	{
		return $this->model;
	}
}
