<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2014 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Plugin\DPCalendar\JCalPro\Model;

\defined('_JEXEC') or die();

use DigitalPeak\Component\DPCalendar\Administrator\Helper\DPCalendarHelper;
use Joomla\CMS\Table\Table;

if (!file_exists(JPATH_ADMINISTRATOR . '/components/com_jcalpro/models/events.php')) {
	return;
}

require_once JPATH_ADMINISTRATOR . '/components/com_jcalpro/models/events.php';
require_once JPATH_ADMINISTRATOR . '/components/com_jcalpro/tables/event.php';
require_once JPATH_ADMINISTRATOR . '/components/com_jcalpro/tables/location.php';

Table::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_jcalpro/tables');

class EventsModel extends \JCalProModelEvents
{
	protected function getListQuery()
	{
		$db    = $this->getDbo();
		$query = parent::getListQuery();

		$startDate = $this->getState('filter.start_date');
		if ($this->getState('list.end-date', null) !== null) {
			$endDate       = $db->quote(DPCalendarHelper::getDate($this->getState('list.end-date'))->toSql());
			$dateCondition = '(a.end_date between ' . $startDate . ' and ' . $endDate . ' or a.start_date between ' . $startDate . ' and ' . $endDate .
				')';
		}
		$endDate       = $this->getState('filter.end_date');
		$dateCondition = '';
		if (!empty($startDate) && !empty($endDate)) {
			$startDateString = $db->quote($startDate->toSql());
			$endDateString   = $db->quote($endDate->toSql());
			$dateCondition   = '(Event.end_date between ' . $startDateString . ' and ' . $endDateString . ' or Event.start_date between ' .
				$startDateString . ' and ' . $endDateString . ')';
		} elseif (!empty($startDate)) {
			$dateCondition = 'a.start_date  >= ' . $db->quote($startDate->toSql());
		} elseif (!empty($endDate)) {
			$dateCondition = 'a.end_date  <= ' . $db->quote($endDate->toSql());
		}

		if ($dateCondition !== '' && $dateCondition !== '0') {
			$query->where($dateCondition);
		}

		// Echo str_replace('#__', 'a_', $query);die;
		return $query;
	}
}
