<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2024 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

\defined('_JEXEC') or die;

use DigitalPeak\Plugin\DPCalendar\JCalPro\Extension\JCalPro;
use DigitalPeak\ThinHTTP\CurlClientFactory;
use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;

return new class () implements ServiceProviderInterface {
	public function register(Container $container): void
	{
		$container->set(
			PluginInterface::class,
			static function (Container $container): JCalPro {
				require_once JPATH_ADMINISTRATOR . '/components/com_dpcalendar/vendor/autoload.php';

				$plugin = new JCalPro(
					$container->get(DispatcherInterface::class),
					(array)PluginHelper::getPlugin('dpcalendar', 'jcalpro')
				);
				$plugin->setApplication(Factory::getApplication());
				$plugin->setClientFactory(new CurlClientFactory());

				return $plugin;
			}
		);
	}
};
