<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2014 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

DPCalendarHelper::loadLibrary(array('jquery' => true, 'bootstrap' => true, 'chosen' => true, 'dpcalendar' => true));

JHtml::_('behavior.tooltip');

$document = JFactory::getDocument();
$document->addScript(JURI::base() . 'components/com_dpcalendar/views/profile/tmpl/default.js');

JText::script('COM_DPCALENDAR_VIEW_DAVCALENDAR_NONE_SELECTED_LABEL');

if ($this->params->get('show_page_heading'))
{?>
	<h1>
		<?php echo $this->escape($this->params->get('page_heading')); ?>
	</h1>
<?php
}?>

<div class="dp-container">
<hr/><h3><?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_SHARING')?></h3>
<form class="dp-profile-form form-horizontal" id="sharingForm">
	<div class="control-group">
		<label id="read-users-lbl" for="read-users" class="hasTip control-label"
			title="<?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_READ_USERS_DESC')?>">
			<?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_READ_USERS_LABEL')?>
		</label>
	    <div class="controls">
		    <select multiple="multiple" id="read-users">
				<?php echo JHtml::_('select.options', $this->users, 'value', 'text', $this->readMembers);?>
			</select>
	    </div>
	</div>
	<div class="control-group">
		<label id="write-users-lbl" for="write-users" class="hasTip control-label"
			title="<?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_WRITE_USERS_DESC')?>">
			<?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_WRITE_USERS_LABEL')?>
		</label>
	    <div class="controls">
		    <select multiple="multiple" id="write-users" class="">
				<?php echo JHtml::_('select.options', $this->users, 'value', 'text', $this->writeMembers);?>
			</select>
	    </div>
	</div>
</form>

<hr/><h3><?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_CALENDARS')?></h3>
<form action="<?php echo JRoute::_('index.php?option=com_dpcalendar&view=profile&Itemid=' . JRequest::getInt('Itemid'));?>"
	method="post" name="adminForm" id="adminForm" class="dp-profile-form form-inline">
<div class="filters btn-toolbar clearfix">
	<div class="btn-group pull-left">
		<input type="text" name="filter-search" id="filter-search" value="<?php echo $this->escape($this->state->get('filter.search'));?>"
			class="input-medium" onchange="this.form.submit();" placeholder="<?php echo JText::_('JGLOBAL_FILTER_LABEL');?>"/>
	</div>
	<div class="btn-group pull-right">
		<select id="limit" name="limit" class="inputbox input-mini" size="1" onchange="this.form.submit()">
			<?php echo JHtml::_('select.options', array(5 => 5, 10 => 10, 15 => 15, 20 => 20, 25 => 25, 30 => 30, 50 => 50, 100 => 100, 0 => JText::_('JALL')),
						'value', 'text', $this->state->get('list.limit'))?>
		</select>
	</div>
</div>
<ul class="list-striped">
<?php foreach ($this->calendars as $url => $calendar)
{?>
<li>
	<?php if (empty($calendar->member_principal_access))
	{?>
	<span class="pull-left width-20">
		<a href="<?php echo JRoute::_('index.php?option=com_dpcalendar&task=davcalendar.delete&return=' . base64_encode(JFactory::getURI()) . '&c_id=' . (int) $calendar->id);?>">
			<i class="hasTip icon-remove" title="<?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_DELETE_PROFILE_CALENDAR')?>"></i>
		</a>
	</span>
	<span class="pull-left width-20">
		<a href="<?php echo DPCalendarHelper::getFormRoute(0, JFactory::getURI(), 'catid=cd-' . (int) $calendar->id);?>">
			<i class="hasTip icon-file" title="<?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_CREATE_EVENT_IN_CALENDAR')?>"></i>
		</a>
	</span>
	<strong class="list-title">
		<a href="<?php echo JRoute::_('index.php?option=com_dpcalendar&task=davcalendar.edit&c_id=' . (int) $calendar->id .
				'&Itemid=' . JRequest::getInt('Itemid') . '&return=' . base64_encode(JRoute::_('index.php?&Itemid=' . JRequest::getInt('Itemid'))));?>">
			<?php echo $calendar->displayname;?>
		</a>
	</strong>
	<?php
	}
	else
	{
		$text = JText::sprintf('COM_DPCALENDAR_VIEW_PROFILE_SHARED_CALENDAR', $calendar->member_principal_name,
				strpos($calendar->member_principal_access, '/calendar-proxy-read') !== false ?
				JText::_('COM_DPCALENDAR_VIEW_PROFILE_SHARED_CALENDAR_ACCESS_READ') :
				JText::_('COM_DPCALENDAR_VIEW_PROFILE_SHARED_CALENDAR_ACCESS_WRITE'));?>
		<span class="pull-left width-20">
			<i class="hasTip icon-lock" title="<?php echo $text?>"></i>
		</span>
		<span class="list-title">
			<?php echo $calendar->displayname;?>
		</span>
	<?php
	}?>
	<span class="list-date small pull-right" style="background-color: #<?php echo $calendar->calendarcolor;?>;width:20px;height:15px"></span>
	<br />
	<small class="list-author"><?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_TABLE_CALDAV_URL_LABEL');?>:
		<a href="<?php echo JUri::base() . 'components/com_dpcalendar/caldav.php/' . $url;?>" target="_blank">
			<?php echo $calendar->uri;?>
		</a>
	</small>
</li>
<?php
}?>
</ul>
<span class="hasTip" title="<?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_CREATE_PROFILE_CALENDAR');?>">
<?php echo JHtml::_('link', JRoute::_('index.php?option=com_dpcalendar&task=davcalendar.add&return=' . base64_encode(JFactory::getURI()) . '&c_id=0'), JHtml::_('image', 'system/new.png', JText::_('JNEW'), null, true));?>
</span>
<div class="pagination">
		<p class="counter pull-right"><?php echo $this->pagination->getPagesCounter();?></p>
		<?php echo $this->pagination->getPagesLinks();?>
</div>
<input type="hidden" name="filter_order" value="" />
<input type="hidden" name="filter_order_Dir" value="" />
<input type="hidden" name="limitstart" value="" />
<input type="hidden" id="token" value="<?php echo JSession::getFormToken();?>"/>
</form>

<hr/><h3><?php echo JText::_('COM_DPCALENDAR_VIEW_PROFILE_UPCOMING_EVENTS')?></h3>
<?php
$content = '<ul class="list-striped">
{{#events}}
<li>
	<span class="badge badge-info pull-right">{{hitsLabel}}: {{hits}}</span>
	{{#canEdit}}
	<span class="pull-left width-20"><a href="{{editLink}}"><i class="hasTip icon-edit" title="{{editLabel}}"></i></a></span>
	{{/canEdit}}
	<strong class="list-title"><a href="{{{backLink}}}">{{title}}</a></strong><small class="list-author"> ({{dateLabel}}: {{date}})</small><br/>
	<small class="list-author">{{calendarNameLabel}}: {{calendarName}}</small>
	<span class="list-date small pull-right">{{#location}}{{full}}{{/location}}</span>
</li>
{{/events}}
</ul>';
echo DPCalendarHelper::renderEvents($this->events, $content);?>
</div>
