<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

class DPCalendarHelperSchema
{

	public static function offer ($event)
	{
		if ($event->price == 0)
		{
			return '';
		}
		$buffer = '';

		$buffer .= '<div ' . JMicrodata::htmlScope('http://schema.org/Offer') . ' ' . JMicrodata::htmlProperty('offers') . '>';
		$buffer .= JMicrodata::htmlMeta(htmlentities($event->price, ENT_QUOTES), 'price');
		$buffer .= JMicrodata::htmlMeta(htmlentities(JText::_('COM_DPCALENDAR_FIELD_CAPACITY_LABEL') . ': ' . $event->capacity, ENT_QUOTES),
				'availability');
		$buffer .= JMicrodata::htmlMeta(htmlentities(DPCalendarHelper::getEventRoute($event->id, $event->catid, true), ENT_QUOTES), 'url');
		$buffer .= '</div>';

		return $buffer;
	}

	public static function location ($locations)
	{
		$buffer = '';

		foreach ($locations as $location)
		{
			$buffer .= '<div ' . JMicrodata::htmlScope('http://schema.org/PostalAddress') . ' ' . JMicrodata::htmlProperty('location') . '>';
			$buffer .= JMicrodata::htmlMeta(htmlentities(DPCalendarHelperLocation::format($location), ENT_QUOTES), 'name');
			$buffer .= JMicrodata::htmlMeta(htmlentities($location->city, ENT_QUOTES), 'addressLocality');
			$buffer .= JMicrodata::htmlMeta(htmlentities($location->province, ENT_QUOTES), 'addressRegion');
			$buffer .= JMicrodata::htmlMeta(htmlentities($location->zip, ENT_QUOTES), 'postalCode');
			$buffer .= JMicrodata::htmlMeta(htmlentities($location->street . ' ' . $location->number, ENT_QUOTES), 'streetAddress');
			$buffer .= JMicrodata::htmlMeta(htmlentities($location->country, ENT_QUOTES), 'addressCountry');
			$buffer .= '</div>';
		}

		return $buffer;
	}
}
