<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

$event = $displayData['event'];
if (! $event)
{
	return;
}
$params = $displayData['params'];
if (! $params)
{
	$params = new JRegistry();
}

$return = JFactory::getApplication()->input->getInt('Itemid', null);
if (! empty($return))
{
	$return = JRoute::_('index.php?Itemid=' . $return);
}
$user = JFactory::getUser();

$description = $event->title . '<br/>' . DPCalendarHelper::getDateStringFromEvent($event, $params->get('event_date_format', 'm.d.Y'),
		$params->get('event_time_format', 'g:i a'));
$description .= '<br/>' . JHtml::_('string.truncate', $event->description, 100) . '<hr id="dp-popup-window-divider"/>';

if (DPCalendarHelper::openForAttending($event))
{
	$description .= ' <a href="' . DPCalendarHelper::getAttendRoute($event, $return) . '">';
	$description .= isset($event->attending) && $event->attending !== null ? JText::_('COM_DPCALENDAR_ATTENDING') : JText::_('COM_DPCALENDAR_ATTEND');

	$description .= '</a>';
}

$calendar = DPCalendarHelper::getCalendar($event->catid);
if ($calendar->canEdit || ($calendar->canEditOwn && $event->created_by == $user->id))
{
	$description .= ' <a href="' . DPCalendarHelper::getFormRoute($event->id, $return) . '">' . JText::_('JACTION_EDIT') . '</a>';
}
if ($calendar->canDelete || ($calendar->canEditOwn && $event->created_by == $user->id))
{
	$description .= ' <a href="' .
			 JRoute::_('index.php?option=com_dpcalendar&task=event.delete&e_id=' . $event->id . '&return=' . base64_encode($return)) . '">' .
			 JText::_('JACTION_DELETE') . '</a>';
}

echo $description;
