dpjQuery(document).ready(
		function() {

			// Parsing the hash
			var today = new Date();
			dpcalendarOptions['year'] = today.getFullYear();
			dpcalendarOptions['month'] = today.getMonth();
			dpcalendarOptions['day'] = today.getDate();
			var vars = window.location.hash.replace(/&amp;/gi, "&").split("&");
			for (var i = 0; i < vars.length; i++) {
				if (vars[i].match("^#year"))
					dpcalendarOptions['year'] = vars[i].substring(6);
				if (vars[i].match("^month"))
					dpcalendarOptions['month'] = vars[i].substring(6) - 1;
				if (vars[i].match("^day"))
					dpcalendarOptions['date'] = vars[i].substring(4);
				if (vars[i].match("^view"))
					dpcalendarOptions['defaultView'] = vars[i].substring(5);
			}

			// Loading the list view when we have a small screen
			if (dpjQuery(document).width() < 500) {
				dpcalendarOptions['defaultView'] = 'list';
			}

			// Some default options
			if (!('header' in dpcalendarOptions)) {
				dpcalendarOptions['header'] = {
					left : 'prev,next ',
					center : 'title',
					right : 'month,agendaWeek,agendaDay,list'
				};
			}
			dpcalendarOptions['weekNumberTitle'] = '';
			dpcalendarOptions['theme'] = false;
			dpcalendarOptions['startParam'] = 'date-start';
			dpcalendarOptions['endParam'] = 'date-end';
			dpcalendarOptions['columnFormat'] = {
				month : 'ddd',
				week : 'ddd d',
				day : 'dddd d'
			};
			dpcalendarOptions['listSections'] = 'smart';
			dpcalendarOptions['listRange'] = 30;
			dpcalendarOptions['listPage'] = 30;

			// Translations
			dpcalendarOptions['allDayText'] = Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_ALL_DAY', true);
			dpcalendarOptions['buttonText'] = {
				today : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_TOOLBAR_TODAY', true),
				month : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_MONTH', true),
				week : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_WEEK', true),
				day : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_DAY', true),
				list : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_LIST', true)
			};

			dpcalendarOptions['listTexts'] = {
				until : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_UNTIL', true),
				past : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_PAST', true),
				today : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_TODAY', true),
				tomorrow : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_TOMORROW', true),
				thisWeek : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_THIS_WEEK', true),
				nextWeek : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_NEXT_WEEK', true),
				thisMonth : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_THIS_MONTH', true),
				nextMonth : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_NEXT_MONTH', true),
				future : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_FUTURE', true),
				week : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_VIEW_TEXTS_WEEK', true)
			};

			var hasMap = dpjQuery('#dpcalendar_component_map').length > 0;

			dpcalendarOptions['viewRender'] = function(view) {
				// Setting the hash based on the actual view
				var d = dpjQuery('#dpcalendar_component').fullCalendar('getDate');
				var newHash = 'year=' + d.getFullYear() + '&month=' + (d.getMonth() + 1) + '&day=' + d.getDate() + '&view=' + view.name;
				if (window.location.hash.replace(/&amp;/gi, "&") != newHash) {
					window.location.hash = newHash;
				}
				if (hasMap) {
					// Clearing the map
					if (dpcalendarMapMarkers != null) {
						for (var i = 0; i < dpcalendarMapMarkers.length; i++) {
							dpcalendarMapMarkers[i].setMap(null);
						}
					}
					dpcalendarMapMarkers = [];
				}
			};
			dpcalendarOptions['eventRender'] = function(event, element) {
				if (event.description && typeof (element.tooltip) == "function") {
					// Adding the tooltip
					element.tooltip({
						html : true,
						title : dpEncode(event.description),
						delay : {
							show : 100,
							hide : event.description.indexOf('task=event.edit') > -1 || event.description.indexOf('task=event.delete') > -1 ? 1500
									: 200
						},
						container : '#dpcalendar_component'
					});
				}

				if (hasMap) {
					var chartUrl = 'http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=%E2%80%A2|';
					if (document.location.protocol == 'https:') {
						chartUrl = 'https://chart.googleapis.com/chart?chst=d_map_pin_letter&chld=%E2%80%A2|';
					}

					// Adding the locations to the map
					dpjQuery.each(event.location, function(i, loc) {
						if (loc.location == undefined || loc.location == '' || loc.location == null)
							return;
						var l = new google.maps.LatLng(loc.latitude, loc.longitude);

						var pinImage = new google.maps.MarkerImage(chartUrl + event.color.replace('#', ''), new google.maps.Size(21, 34),
								new google.maps.Point(0, 0), new google.maps.Point(10, 34));

						var marker = new google.maps.Marker({
							position : l,
							map : dpcalendarMap,
							title : loc.location,
							icon : pinImage
						});
						dpcalendarMapMarkers.push(marker);
						var infowindow = new google.maps.InfoWindow({
							content : event.description
						});
						google.maps.event.addListener(marker, 'click', function() {
							infowindow.open(dpcalendarMap, marker);
						});
						dpcalendarMapBounds.extend(l);
						dpcalendarMap.setCenter(dpcalendarMapBounds.getCenter());
					});
				}
			};

			// Handling the messages in the returned data
			dpcalendarOptions['eventDataTransform'] = function(events) {
				if (events.messages != null && dpjQuery('#system-message-container').length) {
					Joomla.renderMessages(events.messages);
				}
				if (events.data != null) {
					return events.data;
				}
				return events;
			};

			// Drag and drop support
			dpcalendarOptions['eventDrop'] = function(event, dayDelta, minuteDelta, allDay, revertFunc, jsEvent, ui, view) {
				dpjQuery('#dpcalendar_component_loading').show();
				dpjQuery(jsEvent.target).tooltip('hide');
				dpjQuery.ajax({
					type : 'POST',
					url : 'index.php?option=com_dpcalendar&task=event.move',
					data : {
						id : event.id,
						days : dayDelta,
						minutes : minuteDelta,
						allDay : allDay
					},
					success : function(data) {
						dpjQuery('#dpcalendar_component_loading').hide();
						var json = dpjQuery.parseJSON(data);
						if (json.data.url)
							event.url = json.data.url;
						Joomla.renderMessages(json.messages);
					}
				});
			};

			// Resize support
			dpcalendarOptions['eventResize'] = function(event, dayDelta, minuteDelta, revertFunc, jsEvent, ui, view) {
				dpjQuery('#dpcalendar_component_loading').show();
				dpjQuery(jsEvent.target).tooltip('hide');
				dpjQuery.ajax({
					type : 'POST',
					url : 'index.php?option=com_dpcalendar&task=event.move',
					data : {
						id : event.id,
						days : dayDelta,
						minutes : minuteDelta,
						allDay : false,
						onlyEnd : true
					},
					success : function(data) {
						dpjQuery('#dpcalendar_component_loading').hide();
						var json = dpjQuery.parseJSON(data);
						if (json.data.url)
							event.url = json.data.url;
						Joomla.renderMessages(json.messages);
					}
				});
			};

			// Handling clicking on an event
			dpcalendarOptions['eventClick'] = function(event, jsEvent, view) {
				jsEvent.stopPropagation();

				// If we are on a small screen navigate to the page
				if (dpjQuery(window).width() < 600) {
					window.location = dpEncode(event.url);
					return false;
				}

				if (dpcalendarOptions['show_event_as_popup'] == 1) {
					// Opening a BS modal dialog
					dpjQuery('#dpc-event-view').on('show', function() {
						var url = new Url(event.url);
						url.query.tmpl = 'component';
						dpjQuery('#dpc-event-view iframe').attr('src', url.toString());
					});
					dpjQuery('#dpc-event-view').on('hide', function() {
						if (dpjQuery('#dpc-event-view iframe').contents().find('#system-message').children().length > 0) {
							dpjQuery('#dpcalendar_component').fullCalendar('refetchEvents');
						}
						dpjQuery('#dpc-event-view iframe').removeAttr('src');
					});
					var modal = dpjQuery('#dpc-event-view').modal();
					if (dpjQuery(window).width() < modal.width()) {
						modal.css({
							width : dpjQuery(window).width() - 100 + 'px'
						});
					} else {
						modal.css({
							'margin-left' : '-' + modal.width() / 2 + 'px'
						});
					}
				} else if (dpcalendarOptions['show_event_as_popup'] == 3) {
					// Opening the Joomal modal box
					var modal = dpjQuery('#dpc-event-view');
					var width = dpjQuery(window).width();
					var url = new Url(event.url);
					url.query.tmpl = 'component';
					SqueezeBox.open(url.toString(), {
						handler : 'iframe',
						size : {
							x : (width < 650 ? width - (width * 0.10) : modal.width()),
							y : modal.height()
						}
					});
				} else {
					// Just navigate to the event
					window.location = dpEncode(event.url);
				}
				return false;
			};

			dpcalendarOptions['dayClick'] = function(date, allDay, jsEvent, view) {
				if (dpjQuery('#editEventFormComponent').length > 0) {
					// On small screens open the edit page directly
					if (dpjQuery(window).width() < 600) {
						dpjQuery('#editEventFormComponent #task').val('');
						dpjQuery('#editEventFormComponent').submit();
						return false;
					}
					jsEvent.stopPropagation();

					// Setting some defaults on the quick add popup form
					if (view.name == 'month')
						date.setHours(8);
					dpjQuery('#editEventFormComponent #jform_start_date').datepicker('setDate', date);
					dpjQuery('#editEventFormComponent #jform_start_date_time').timepicker('setTime', date);
					dpjQuery('#editEventFormComponent #jform_end_date').datepicker('setDate', date);
					date.setHours(date.getHours() + 1);
					dpjQuery('#editEventFormComponent #jform_end_date_time').timepicker('setTime', date);
					var p = dpjQuery('#dpcalendar_component').parents().filter(function() {
						var parent = dpjQuery(this);
						return parent.is('body') || parent.css('position') == 'relative';
					}).slice(0, 1).offset();

					if (dpcalendarOptions['event_edit_popup'] == 1) {
						// Show the quick add popup
						dpjQuery('#editEventFormComponent').css({
							top : jsEvent.pageY - p.top,
							left : jsEvent.pageX - 160 - p.left
						}).show();
						dpjQuery('#editEventFormComponent #jform_title').focus();
					} else {
						// Open the edit page
						dpjQuery('#editEventFormComponent #task').val('');
						dpjQuery('#editEventFormComponent').submit();
					}
				} else {
					// The edit form is not loaded, navigate to the day
					dpjQuery('#dpcalendar_component').fullCalendar('gotoDate', date).fullCalendar('changeView', 'agendaDay');
				}
			};

			// Spinner handling
			dpcalendarOptions['loading'] = function(bool) {
				if (bool) {
					dpjQuery('#dpcalendar_component_loading').show();
				} else {
					dpjQuery('#dpcalendar_component_loading').hide();
				}
			};

			// Loading the calendar
			dpjQuery('#dpcalendar_component').fullCalendar(dpcalendarOptions);

			if (hasMap) {
				var dpcalendarMap = new google.maps.Map(document.getElementById('dpcalendar_component_map'), {
					zoom : dpcalendarOptions['map_zoom'],
					mapTypeId : google.maps.MapTypeId.ROADMAP,
					center : new google.maps.LatLng(dpcalendarOptions['map_lat'], dpcalendarOptions['map_long'])
				});
				var dpcalendarMapBounds = new google.maps.LatLngBounds();
				var dpcalendarMapMarkers = [];
			}
			// Adding the custom buttons
			var custom_buttons = '<span class="fc-button fc-button-datepicker fc-state-default fc-corner-left fc-corner-right">'
					+ '<span class="fc-button-inner"><span class="fc-button-content" id="dpcalendar_component_date_picker_button">'
					+ '<input type="hidden" id="dpcalendar_component_date_picker" value="">' + '<i class="icon-calendar" title="'
					+ Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_SHOW_DATEPICKER') + '"></i>' + '</span></span></span>';
			custom_buttons += '<span class="hidden-phone fc-button fc-button-print fc-state-default fc-corner-left fc-corner-right">'
					+ '<span class="fc-button-inner"><span class="fc-button-content" id="dpcalendar_component_print_button">'
					+ '<i class="icon-print" title="' + Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_TOOLBAR_PRINT') + '"></i>'
					+ '</span></span></span>';
			dpjQuery('span.fc-header-space').after(custom_buttons);

			// Initializing the datepicker
			dpjQuery("#dpcalendar_component_date_picker").datepicker({
				dateFormat : 'dd-mm-yy',
				changeYear : true,
				dayNames : dpcalendarOptions['dayNames'],
				dayNamesShort : dpcalendarOptions['dayNamesShort'],
				dayNamesMin : dpcalendarOptions['dayNamesMin'],
				monthNames : dpcalendarOptions['monthNames'],
				monthNamesShort : dpcalendarOptions['monthNamesShort'],
				firstDay : dpcalendarOptions['firstDay'],
				showButtonPanel : true,
				closeText : Joomla.JText._('JCANCEL', true),
				currentText : Joomla.JText._('COM_DPCALENDAR_VIEW_CALENDAR_TOOLBAR_TODAY', true),
				onSelect : function(dateText, inst) {
					var d = dpjQuery('#dpcalendar_component_date_picker').datepicker('getDate');
					var view = dpjQuery('#dpcalendar_component').fullCalendar('getView').name;
					dpjQuery('#dpcalendar_component').fullCalendar('gotoDate', d);
				}
			});
			dpjQuery('.ui-widget-overlay').on('click', function() {
				dpjQuery('#dpcalendar-dialog').dialog('close');
			});

			// Listening for hash/url changes
			dpjQuery(window).bind('hashchange', function() {
				var today = new Date();
				var tmpYear = today.getFullYear();
				var tmpMonth = today.getMonth();
				var tmpDay = today.getDate();
				var tmpView = dpcalendarOptions['defaultView'];
				var vars = window.location.hash.replace(/&amp;/gi, "&").split("&");
				for (var i = 0; i < vars.length; i++) {
					if (vars[i].match("^#year"))
						tmpYear = vars[i].substring(6);
					if (vars[i].match("^month"))
						tmpMonth = vars[i].substring(6) - 1;
					if (vars[i].match("^day"))
						tmpDay = vars[i].substring(4);
					if (vars[i].match("^view"))
						tmpView = vars[i].substring(5);
				}
				var date = new Date(tmpYear, tmpMonth, tmpDay, 0, 0, 0);
				var d = dpjQuery('#dpcalendar_component').fullCalendar('getDate');
				var view = dpjQuery('#dpcalendar_component').fullCalendar('getView');
				if (date.getFullYear() != d.getFullYear() || date.getMonth() != d.getMonth() || date.getDate() != d.getDate())
					dpjQuery('#dpcalendar_component').fullCalendar('gotoDate', date);
				if (view.name != tmpView)
					dpjQuery('#dpcalendar_component').fullCalendar('changeView', tmpView);
			});

			if (dpjQuery('table').disableSelection)
				dpjQuery('div.fc-button-today').closest('table.fc-header').disableSelection();

			// Showing the date picker
			dpjQuery(document).on('click', '#dpcalendar_component_date_picker_button', function(e) {
				dpjQuery('#dpcalendar_component_date_picker').datepicker('show');
			});

			// Go to the print page
			dpjQuery(document).on('click', '#dpcalendar_component_print_button', function(e) {
				var loc = document.location.href.replace(/\?/, "\?layout=print&format=raw\&");
				if (loc == document.location.href)
					loc = document.location.href.replace(/#/, "\?layout=print&format=raw#");
				var printWindow = window.open(loc);
				printWindow.focus();
			});

			// Toggle the list of calendars
			dpjQuery('#dpcalendar_view_toggle_status').bind('click', function(e) {
				dpjQuery('#dpcalendar_view_list').slideToggle('slow', function() {
					var iconClass = 'icon-arrow-up';
					if (!dpjQuery('#dpcalendar_view_list').is(":visible"))
						iconClass = 'icon-arrow-down';

					dpjQuery('#dpcalendar_view_toggle_status').attr('class', iconClass);
				});
			});
		});

function updateDPCalendarFrame(calendar) {
	if (calendar.checked) {
		dpjQuery('#dpcalendar_component').fullCalendar('addEventSource', calendar.value);
	} else {
		dpjQuery('#dpcalendar_component').fullCalendar('removeEventSource', calendar.value);
	}
}
