<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2015 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

defined('_JEXEC') or die();

DPCalendarHelper::loadLibrary(array('jquery' => true, 'bootstrap' => true, 'fullcalendar' => true, 'dpcalendar' => true));

if (DPCalendarHelper::isJoomlaVersion('3.3', '<'))
{
	JHtml::_('behavior.framework');
}

JHtml::_('script', 'system/core.js', false, true);

$document = JFactory::getDocument();

$moduleId = $module->id;
$color = $params->get('event_color', '135CAE');
$cssClass = "dpcal-module_event_dpcal_" . $moduleId;
$document->addStyleDeclaration("." . $cssClass . ",." . $cssClass . " a, ." . $cssClass . " div{background-color:transparent; !important; border-color: #" . $color . "} .fc-header-center{vertical-align: middle !important;} #dpcalendar_module_" . $moduleId . " .fc-state-default span, #dpcalendar_module_" . $moduleId . " .ui-state-default{padding:0px !important;}");
$document->addStyleDeclaration(".fc-header-title h2 {
	line-height: 20px;
	font-size: 19px;
}

.fc-header tr,.fc-header-title h2,.fc-header,.fc-header td {
	border: 0px;
}

#dp-popup-window-divider {
	margin: 0;
}");

$canAdd = DPCalendarHelper::canCreateEvent();

$daysLong = array();
$daysShort =array();
$monthsLong = array();
$monthsShort = array();
for ($i = 0; $i < 7; $i++)
{
	$daysLong[] = DPCalendarHelper::dayToString($i, false);
	$daysShort[] = DPCalendarHelper::dayToString($i, true) ;
}
for ($i = 1; $i <= 12; $i++)
{
	$monthsLong[] = DPCalendarHelper::monthToString($i, false) ;
	$monthsShort[] = DPCalendarHelper::monthToString($i, true) ;
}

$calCode = "// <![CDATA[ \n";
$calCode .= "dpjQuery(document).ready(function(){\n";

$calCode .= "   dpjQuery('#dpcalendar_module_" . $moduleId . "').fullCalendar({\n";
$calCode .= "		events: '" . html_entity_decode(JRoute::_('index.php?option=com_dpcalendar&view=events&limit=0&compact=' .
		$params->get('compact_events', 1) . '&format=raw&ids=' . implode(',', $ids))) . "',\n";
$calCode .= "       header: {\n";
$calCode .= "				left: 'prev,next ',\n";
$calCode .= "				center: 'title',\n";
$calCode .= "				right: ''\n";
$calCode .= "		},\n";
$calCode .= "		defaultView: 'month',\n";
$calCode .= "		eventClick: function(event, jsEvent, view) {\n";

if ($params->get('show_event_as_popup', 2) == 1)
{
	$calCode .= "		        if (dpjQuery(window).width() < 600) {window.location = dpEncode(event.url); return false;}\n";
	$calCode .= "		        dpjQuery('#dpc-event-view-" . $moduleId . "').on('show', function () {\n";
	$calCode .= "		            var url = new Url(event.url);\n";
	$calCode .= "		            url.query.tmpl = 'component';\n";
	$calCode .= "		            dpjQuery('#dpc-event-view-" . $moduleId . " iframe').attr('src', url.toString());\n";
	$calCode .= "		        });\n";
	$calCode .= "		        dpjQuery('#dpc-event-view-" . $moduleId . "').on('hide', function () {\n";
	$calCode .= "		           if(dpjQuery('#dpc-event-view-" . $moduleId . " iframe').contents().find('#system-message').children().length > 0){dpjQuery('#dpcalendar_module_" . $moduleId . "').fullCalendar('refetchEvents');}\n";
	$calCode .= "		            dpjQuery('#dpc-event-view-" . $moduleId . " iframe').removeAttr('src');\n";
	$calCode .= "		        });\n";
	$calCode .= "		        dpjQuery('#dpc-event-view-" . $moduleId . "').modal();\n";
	$calCode .= "		        return false;\n";
}
else
{
	$calCode .= "		        window.location = dpEncode(event.url); return false;\n";
}
$calCode .= "		},\n";

$calCode .= "		dayClick: function(date, allDay, jsEvent, view) {\n";

if ($canAdd)
{
	$calCode .= "    jsEvent.stopPropagation();\n";
	$calCode .= "    dpjQuery('#editEventForm" . $moduleId . " #jform_start_date').datepicker('setDate', date);\n";
	$calCode .= "    dpjQuery('#editEventForm" . $moduleId . " #jform_start_date_time').timepicker('setTime', date);\n";
	$calCode .= "    dpjQuery('#editEventForm" . $moduleId . " #jform_end_date').datepicker('setDate', date);\n";
	$calCode .= "    date.setHours(date.getHours()+1);\n";
	$calCode .= "    dpjQuery('#editEventForm" . $moduleId . " #jform_end_date_time').timepicker('setTime', date);\n";
	$calCode .= "    var p = dpjQuery('#dpcalendar_module_" . $moduleId . "').parents().filter(function() {\n";
	$calCode .= "    	var parent = dpjQuery(this);\n";
	$calCode .= "    	return parent.is('body') || parent.css('position') == 'relative';\n";
	$calCode .= "    }).slice(0,1).offset();\n";

	if ($params->get('event_edit_popup', 1) == 1)
	{
		$calCode .= "    dpjQuery('#editEventForm" . $moduleId . "').css({top: jsEvent.pageY-p.top, left: jsEvent.pageX-160-p.left}).show();\n";
	}
	else
	{
		$calCode .= "    dpjQuery('#editEventForm" . $moduleId . " #task').val('');\n";
		$calCode .= "    dpjQuery('#editEventForm" . $moduleId . "').submit();\n";
	}
	$calCode .= "    dpjQuery('#editEventForm" . $moduleId . " #jform_title').focus();\n";
}
$calCode .= "		},\n";

$height = $params->get('calendar_height', null);
if (!empty($height))
{
	$calCode .= "		contentHeight: " . $height . ",\n";
}
$calCode .= "		editable: false, theme: false,\n";
$calCode .= "		titleFormat: { \n";
$calCode .= "		        month: '" . DPFullcalendar::convertFromPHPDate($params->get('titleformat_month', 'M Y')) . "'},\n";
$calCode .= "		firstDay: " . $params->get('weekstart', 0) . ",\n";
$calCode .= "		monthNames: " . json_encode($monthsLong) . ",\n";
$calCode .= "		monthNamesShort: " . json_encode($monthsShort) . ",\n";
$calCode .= "		dayNames: " . json_encode($daysLong) . ",\n";
$calCode .= "		dayNamesShort: " . json_encode($daysShort) . ",\n";
$calCode .= "		startParam: 'date-start',\n";
$calCode .= "		endParam: 'date-end',\n";
$calCode .= "		timeFormat: { \n";
$calCode .= "		        month: '" . DPFullcalendar::convertFromPHPDate($params->get('timeformat_month', 'g:i a')) . "'},\n";
$calCode .= "		columnFormat: { month: 'ddd', week: 'ddd d', day: 'dddd d'},\n";
$calCode .= "		eventRender: function(event, element) {\n";
$calCode .= "			element.addClass('dpcal-module_event_dpcal_'+" . $moduleId . ");\n";
$calCode .= "			if (event.description){\n";
$calCode .= "				element.tooltip({html: true, title: event.description, delay: { show: 100, hide: 500}, container: '#dpcalendar_module_" . $moduleId . "'});}\n";
$calCode .= "		},\n";
$calCode .= "		eventDataTransform: function(events){\n";
$calCode .= "			if(events.messages != null && dpjQuery('#system-message-container').length){ Joomla.renderMessages(events.messages);}\n";
$calCode .= "			if(events.data != null){ return events.data;}return events;\n";
$calCode .= "		},\n";
$calCode .= "		loading: function(bool) {\n";
$calCode .= "			if (bool) {\n";
$calCode .= "				dpjQuery('#dpcalendar_module_" . $moduleId . "_loading').show();\n";
$calCode .= "			}else{\n";
$calCode .= "				dpjQuery('#dpcalendar_module_" . $moduleId . "_loading').hide();\n";
$calCode .= "			}\n";
$calCode .= "		}\n";
$calCode .= "	});\n";
$calCode .= "});\n";
$calCode .= "// ]]>\n";
$document->addScriptDeclaration($calCode);

$width = $params->get('popup_width', 0) ? 'width:' . $params->get('popup_width', 0) . 'px;':'';
$height = $params->get('popup_height', 500) ? 'height:' . $params->get('popup_height', 500) . 'px;':'';
?>
<div class="dp-container" data-id="<?php echo $moduleId ?>">
	<div id="dpcalendar_module_<?php echo $moduleId ?>_loading" style="text-align: center;">
		<img src="<?php echo JUri::base() ?>media/com_dpcalendar/images/site/ajax-loader.gif" alt="loader"/>
	</div>
	<div id="dpcalendar_module_<?php echo $moduleId ?>"></div>
	<div id="dpcalendar_module_<?php echo $moduleId ?>_popup" style="visibility:hidden"></div>
	<div id="dpc-event-view-<?php echo $moduleId ?>" class="modal hide" tabindex="-1" role="dialog" aria-hidden="true"
		style="<?php echo $width . $height?>">
	    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
	  	<iframe style="width:99.6%;height:95%;border:none;"></iframe>
	</div>
</div>

<?php
if ($canAdd)
{
	$merged = clone JComponentHelper::getParams('com_dpcalendar');
	$merged->merge($params);
	$merged->set('uniqueIdentifier', $moduleId);
	echo JLayoutHelper::render('event.quickadd', array('params' => $merged), null, array('component' => 'com_dpcalendar'));
}
