<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2016 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
define('_JEXEC', 1);
define('DS', DIRECTORY_SEPARATOR);

$path = dirname(dirname(dirname(__FILE__)));
if (isset($_SERVER["SCRIPT_FILENAME"]))
{
	$path = dirname(dirname(dirname($_SERVER["SCRIPT_FILENAME"])));
}

define('JPATH_BASE', $path);
require_once JPATH_BASE . DS . 'includes' . DS . 'defines.php';
require_once JPATH_BASE . DS . 'includes' . DS . 'framework.php';

JLoader::import('joomla.user.authentication');
JLoader::import('joomla.application.component.helper');

JLog::addLogger(array(
		'text_file' => 'com_dpcalendar.caldav.errors.php'
), JLog::ALL, 'com_dpcalendar');

class DPCalendarCalDavServer extends JApplicationCms
{

	public function __construct(JInput $input = null, JRegistry $config = null, JApplicationWebClient $client = null)
	{
		parent::__construct($input, $config, $client);

		$this->config->set('caching', 0);
	}

	public function doExecute()
	{

		function exception_error_handler($errno, $errstr, $errfile, $errline)
		{
			JLog::add('Something crashed during a CalDAV request on ' . $errfile . ' ' . $errline . PHP_EOL . $errstr, JLog::ERROR, 'com_dpcalendar');
			throw new \ErrorException($errstr, 0, $errno, $errfile, $errline);
		}
		set_error_handler("exception_error_handler");

		try
		{
			JLoader::import('components.com_dpcalendar.helpers.dpcalendar', JPATH_ADMINISTRATOR);

			$config = JFactory::getConfig();
			$config->set('caching', 0);

			$pdo = new \PDO('mysql:host=' . $config->get('host') . ';dbname=' . $config->get('db'), $config->get('user'), $config->get('password'));
			$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

			JFactory::getApplication()->input->set('format', 'raw');

			$authBackend = new \DPCalendar\Sabre\DAV\Auth\Backend\Joomla(JFactory::getDbo());
			$calendarBackend = new \DPCalendar\Sabre\CalDAV\Backend\DPCalendar($pdo, $config->get('dbprefix') . 'dpcalendar_caldav_calendars',
					$config->get('dbprefix') . 'dpcalendar_caldav_calendarobjects');
			$principalBackend = new \Sabre\DAVACL\PrincipalBackend\PDO($pdo, $config->get('dbprefix') . 'dpcalendar_caldav_principals',
					$config->get('dbprefix') . 'dpcalendar_caldav_groupmembers');

			$tree = array(
					new \Sabre\CalDAV\Principal\Collection($principalBackend),
					new \Sabre\CalDAV\CalendarRootNode($principalBackend, $calendarBackend)
			);

			\Sabre\DAV\Server::$exposeVersion = false;

			$server = new \Sabre\DAV\Server($tree);

			$uri = trim(JUri::root(true), '/');
			if (strpos($uri, 'components/com_dpcalendar') === false)
			{
				$uri .= '/components/com_dpcalendar/';
			}
			$uri = '/' . trim($uri, '/') . '/' . 'caldav.php';
			$server->setBaseUri($uri);

			$server->addPlugin(new \Sabre\DAV\Auth\Plugin($authBackend, 'SabreDAV'));
			$server->addPlugin(new \Sabre\DAVACL\Plugin());
			$server->addPlugin(new \Sabre\CalDAV\Plugin());

			$server->addPlugin(new \Sabre\DAV\Browser\Plugin());

			$server->exec();
		}
		catch (Exception $e)
		{
			$message = 'Something crashed during a CalDAV request: ' . PHP_EOL . $e;
			JLog::add($message, JLog::ERROR, 'com_dpcalendar');

			$DOM = new \DOMDocument('1.0', 'utf-8');
			$DOM->formatOutput = true;

			$error = $DOM->createElementNS('DAV:', 'd:error');
			$error->setAttribute('xmlns:s', \Sabre\DAV\Server::NS_SABREDAV);
			$DOM->appendChild($error);

			$error->appendChild($DOM->createElement('s:exception', htmlspecialchars(get_class($e), ENT_NOQUOTES, 'UTF-8')));
			$error->appendChild($DOM->createElement('s:message', htmlspecialchars($e->getMessage(), ENT_NOQUOTES, 'UTF-8')));

			header('Content-Type:application/xml; charset=utf-8');
			http_response_code(500);
			echo $DOM->saveXML();
		}
	}

	public function enqueueMessage($msg, $type = 'message')
	{
		JLog::add('A message was thrown of type ' . $type . ' during a CalDAV request: ' . PHP_EOL . $msg, JLog::ERROR, 'com_dpcalendar');
	}

	public function getCfg($varname, $default = null)
	{
		$config = JFactory::getConfig();
		return $config->get('' . $varname, $default);
	}

	public static function getRouter($name = '', array $options = array())
	{
		JLoader::import('joomla.application.router');

		try
		{
			return new JRouter($options);
		}
		catch (Exception $e)
		{
			return null;
		}
	}

	public function getMenu($name = 'site', $options = array())
	{
		try
		{
			return JMenu::getInstance($name, $options);
		}
		catch (Exception $e)
		{
			return null;
		}
	}

	public function getClientId()
	{
		return 0;
	}

	public function isSite()
	{
		return true;
	}

	public function isAdmin()
	{
		return false;
	}

	public function getLanguageFilter()
	{
		return false;
	}

	public function getParams()
	{
		return new JRegistry();
	}

	public function getUserState($key, $default = null)
	{
		$session = JFactory::getSession();
		$registry = $session->get('registry');

		if (!is_null($registry))
		{
			return $registry->get($key, $default);
		}

		return $default;
	}

	public function getUserStateFromRequest($key, $request, $default = null, $type = 'none')
	{
		$cur_state = $this->getUserState($key, $default);
		$new_state = $this->input->get($request, null, $type);

		// Save the new value only if it was set in this request.
		if ($new_state !== null)
		{
			$this->setUserState($key, $new_state);
		}
		else
		{
			$new_state = $cur_state;
		}

		return $new_state;
	}

	public function setUserState($key, $value)
	{
		$session = JFactory::getSession();
		$registry = $session->get('registry');

		if (!is_null($registry))
		{
			return $registry->set($key, $value);
		}

		return null;
	}
}

$app = JApplicationWeb::getInstance('DPCalendarCalDavServer');
JFactory::$application = $app;
$app->execute();
