<?php
/**
 * @package    DPCalendar
 * @author     Digital Peak http://www.digital-peak.com
 * @copyright  Copyright (C) 2007 - 2016 Digital Peak. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
defined('_JEXEC') or die();

JFormHelper::addFieldPath(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_categories' . DS . 'models' . DS . 'fields');
JFormHelper::loadFieldClass('categoryedit');

class JFormFieldDPCalendarEdit extends JFormFieldCategoryEdit
{

	public $type = 'DPCalendarEdit';

	protected function getOptions()
	{
		$app = JFactory::getApplication();
		$calendar = null;
		$id = $app->isAdmin() ? 0 : JRequest::getVar('id');
		if (!empty($id))
		{
			$calendar = DPCalendarHelper::getCalendar($this->value);
		}

		$options = array();
		if (empty($calendar) || !$calendar->external)
		{
			$options = parent::getOptions();
		}

		if (empty($calendar) || $calendar->external)
		{
			JPluginHelper::importPlugin('dpcalendar');
			$tmp = JDispatcher::getInstance()->trigger('onCalendarsFetch',
					array(
							null,
							!empty($calendar->system) ? $calendar->system : null
					));
			if (!empty($tmp))
			{
				foreach ($tmp as $calendars)
				{
					foreach ($calendars as $externalCalendar)
					{
						if (!$externalCalendar->canCreate && !$externalCalendar->canEdit)
						{
							continue;
						}
						$options[] = JHtml::_('select.option', $externalCalendar->id, '- ' . $externalCalendar->title);
					}
				}
			}
		}

		$ids = array();
		if ($app->isSite())
		{
			$activeMenu = $app->getMenu()->getActive();
			if (isset($activeMenu) && $app->input->get('option') == 'com_dpcalendar')
			{
				$params = $activeMenu->params;
				$ids = $params->get('ids', array());
			}
		}
		usort($options,
				function ($c1, $c2) use ($ids)
				{
					if (in_array($c1->value, $ids) && !in_array($c2->value, $ids))
					{
						return -1;
					}
					if (in_array($c2->value, $ids) && !in_array($c1->value, $ids))
					{
						return 1;
					}

					return strcmp($c1->text, $c2->text);
				});

		return $options;
	}
}
