ALTER TABLE `#__dpcalendar_events` ADD `schedule` TEXT NULL AFTER `description`;
ALTER TABLE `#__dpcalendar_events` DROP `tax`;

ALTER TABLE `#__dpcalendar_bookings` ADD `invoice` LONGTEXT NULL AFTER `currency`;
ALTER TABLE `#__dpcalendar_bookings` ADD `tax` DECIMAL(10, 2) NOT NULL DEFAULT '0.00' AFTER `invoice`;
ALTER TABLE `#__dpcalendar_bookings` ADD `tax_rate` DECIMAL(10, 5) DEFAULT NULL AFTER `tax`;

ALTER TABLE `#__dpcalendar_locations` ADD `metadata` TEXT NULL AFTER `publish_down`;

CREATE TABLE IF NOT EXISTS `#__dpcalendar_taxrates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `rate` DECIMAL(10, 5) DEFAULT NULL,
  `countries` text,
  `inclusive` tinyint(1) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_createdby` (`created_by`)
) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `#__dpcalendar_countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `short_code` varchar(10) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_short_code` (`short_code`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_createdby` (`created_by`)
) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

INSERT INTO `#__dpcalendar_countries` (`short_code`, `state`) VALUES
('AF', 1),
('AX', 1),
('AL', 1),
('DZ', 1),
('AS', 1),
('AD', 1),
('AO', 1),
('AI', 1),
('AQ', 1),
('AG', 1),
('AR', 1),
('AM', 1),
('AW', 1),
('AC', 1),
('AU', 1),
('AT', 1),
('AZ', 1),
('BS', 1),
('BH', 1),
('BD', 1),
('BB', 1),
('BY', 1),
('BE', 1),
('BZ', 1),
('BJ', 1),
('BM', 1),
('BT', 1),
('BO', 1),
('BA', 1),
('BW', 1),
('BR', 1),
('IO', 1),
('VG', 1),
('BN', 1),
('BG', 1),
('BF', 1),
('BI', 1),
('KH', 1),
('CM', 1),
('CA', 1),
('IC', 1),
('CV', 1),
('BQ', 1),
('KY', 1),
('CF', 1),
('EA', 1),
('TD', 1),
('CL', 1),
('CN', 1),
('CX', 1),
('CC', 1),
('CO', 1),
('KM', 1),
('CG', 1),
('CD', 1),
('CK', 1),
('CR', 1),
('CI', 1),
('HR', 1),
('CU', 1),
('CW', 1),
('CY', 1),
('CZ', 1),
('DK', 1),
('DG', 1),
('DJ', 1),
('DM', 1),
('DO', 1),
('EC', 1),
('EG', 1),
('SV', 1),
('GQ', 1),
('ER', 1),
('EE', 1),
('SZ', 1),
('ET', 1),
('FK', 1),
('FO', 1),
('FJ', 1),
('FI', 1),
('FR', 1),
('GF', 1),
('PF', 1),
('TF', 1),
('GA', 1),
('GM', 1),
('GE', 1),
('DE', 1),
('GH', 1),
('GI', 1),
('GR', 1),
('GL', 1),
('GD', 1),
('GP', 1),
('GU', 1),
('GT', 1),
('GG', 1),
('GN', 1),
('GW', 1),
('GY', 1),
('HT', 1),
('HN', 1),
('HK', 1),
('HU', 1),
('IS', 1),
('IN', 1),
('ID', 1),
('IR', 1),
('IQ', 1),
('IE', 1),
('IM', 1),
('IL', 1),
('IT', 1),
('JM', 1),
('JP', 1),
('JE', 1),
('JO', 1),
('KZ', 1),
('KE', 1),
('KI', 1),
('XK', 1),
('KW', 1),
('KG', 1),
('LA', 1),
('LV', 1),
('LB', 1),
('LS', 1),
('LR', 1),
('LY', 1),
('LI', 1),
('LT', 1),
('LU', 1),
('MO', 1),
('MG', 1),
('MW', 1),
('MY', 1),
('MV', 1),
('ML', 1),
('MT', 1),
('MH', 1),
('MQ', 1),
('MR', 1),
('MU', 1),
('YT', 1),
('MX', 1),
('FM', 1),
('MD', 1),
('MC', 1),
('MN', 1),
('ME', 1),
('MS', 1),
('MA', 1),
('MZ', 1),
('MM', 1),
('NA', 1),
('NR', 1),
('NP', 1),
('NL', 1),
('NC', 1),
('NZ', 1),
('NI', 1),
('NE', 1),
('NG', 1),
('NU', 1),
('NF', 1),
('KP', 1),
('MK', 1),
('MP', 1),
('NO', 1),
('OM', 1),
('PK', 1),
('PW', 1),
('PS', 1),
('PA', 1),
('PG', 1),
('PY', 1),
('PE', 1),
('PH', 1),
('PN', 1),
('PL', 1),
('PT', 1),
('XA', 1),
('XB', 1),
('PR', 1),
('QA', 1),
('RE', 1),
('RO', 1),
('RU', 1),
('RW', 1),
('WS', 1),
('SM', 1),
('ST', 1),
('SA', 1),
('SN', 1),
('RS', 1),
('SC', 1),
('SL', 1),
('SG', 1),
('SX', 1),
('SK', 1),
('SI', 1),
('SB', 1),
('SO', 1),
('ZA', 1),
('GS', 1),
('KR', 1),
('SS', 1),
('ES', 1),
('LK', 1),
('BL', 1),
('SH', 1),
('KN', 1),
('LC', 1),
('MF', 1),
('PM', 1),
('VC', 1),
('SD', 1),
('SR', 1),
('SJ', 1),
('SE', 1),
('CH', 1),
('SY', 1),
('TW', 1),
('TJ', 1),
('TZ', 1),
('TH', 1),
('TL', 1),
('TG', 1),
('TK', 1),
('TO', 1),
('TT', 1),
('TA', 1),
('TN', 1),
('TR', 1),
('TM', 1),
('TC', 1),
('TV', 1),
('UG', 1),
('UA', 1),
('AE', 1),
('GB', 1),
('US', 1),
('UY', 1),
('UM', 1),
('VI', 1),
('UZ', 1),
('VU', 1),
('VA', 1),
('VE', 1),
('VN', 1),
('WF', 1),
('EH', 1),
('YE', 1),
('ZM', 1),
('ZW', 1);
