/*!
 * Lightweight URL manipulation with JavaScript
 * This library is independent of any other libraries and has pretty simple
 * interface and lightweight code-base.
 * Some ideas of query string parsing had been taken from Jan Wolter
 * @see http://unixpapa.com/js/querystring.html
 *
 * @license MIT
 * @author Mykhailo Stadnyk <mikhus@gmail.com> and contributors
 * @see https://github.com/Mikhus/domurl/graphs/contributors
 */
!function(t){"use strict";var r=/^[a-z]+:/,e=/[-a-z0-9]+(\.[-a-z0-9])*:\d+/i,o=/\/\/(.*?)(?::(.*?))?@/,n=/^win/i,i=/:$/,a=/^\?/,s=/^#/,p=/(.*\/)/,h=/^\/{2,}/,u=/(^\/?)/,c=/'/g,f=/%([ef][0-9a-f])%([89ab][0-9a-f])%([89ab][0-9a-f])/gi,l=/%([cd][0-9a-f])%([89ab][0-9a-f])/gi,y=/%([0-7][0-9a-f])/gi,d=/\+/g,v=/^\w:$/,g=/[^/#?]/;var m,q="undefined"==typeof window&&"undefined"!=typeof global&&"function"==typeof require,w=!q&&t.navigator&&t.navigator.userAgent&&~t.navigator.userAgent.indexOf("MSIE"),A=q?t.require:null,I={protocol:"protocol",host:"hostname",port:"port",path:"pathname",query:"search",hash:"hash"},C={ftp:21,gopher:70,http:80,https:443,ws:80,wss:443};function S(){return q?(m||(m="file://"+(process.platform.match(n)?"/":"")+A("fs").realpathSync(".")),m):"about:srcdoc"===document.location.href?self.parent.document.location.href:document.location.href}function b(t,n,c){var f,l,y;n||(n=S()),q?f=A("url").parse(n):(f=document.createElement("a")).href=n;var d=// configure given url options
function(t){var n={path:!0,query:!0,hash:!0};return t?(r.test(t)&&(n.protocol=!0,n.host=!0,e.test(t)&&(n.port=!0),o.test(t)&&(n.user=!0,n.pass=!0)),n):n}(n);for(l in y=n.match(o)||[],I)d[l]?t[l]=f[I[l]]||"":t[l]="";// fix-up some parts
if(t.protocol=t.protocol.replace(i,""),t.query=t.query.replace(a,""),t.hash=j(t.hash.replace(s,"")),t.user=j(y[1]||""),t.pass=j(y[2]||""),
/* jshint ignore:start */
t.port=// loosely compare because port can be a string
C[t.protocol]==t.port||0==t.port?"":t.port,// IE fix, Android browser fix
/* jshint ignore:end */
!d.protocol&&g.test(n.charAt(0))&&(t.path=n.split("?")[0].split("#")[0]),!d.protocol&&c){
// is IE and path is relative
var v=new E(S().match(p)[0]),m=v.path.split("/"),b=t.path.split("/"),x=["protocol","user","pass","host","port"],F=x.length;for(m.pop(),l=0;l<F;l++)t[x[l]]=v[x[l]];for(;".."===b[0];)
// skip all "../
m.pop(),b.shift();t.path=("/"!==n.charAt(0)?m.join("/"):"")+"/"+b.join("/")}t.path=t.path.replace(h,"/"),w&&(t.path=t.path.replace(u,"/")),t.paths(t.paths()),t.query=new z(t.query)}function x(t){return encodeURIComponent(t).replace(c,"%27")}function j(t){return(t=(t=(t=t.replace(d," ")).replace(f,(function(t,r,e,o){var n=parseInt(r,16)-224,i=parseInt(e,16)-128;if(0===n&&i<32)return t;var a=(n<<12)+(i<<6)+(parseInt(o,16)-128);return a>65535?t:String.fromCharCode(a)}))).replace(l,(function(t,r,e){var o=parseInt(r,16)-192;if(o<2)return t;var n=parseInt(e,16)-128;return String.fromCharCode((o<<6)+n)}))).replace(y,(function(t,r){return String.fromCharCode(parseInt(r,16))}))}
/**
   * Class QueryString
   *
   * @param {string} qs - string representation of QueryString
   * @constructor
   */function z(t){for(var r=t.split("&"),e=0,o=r.length;e<o;e++){var n=r[e].split("="),i=decodeURIComponent(n[0].replace(d," "));if(i){var a=void 0!==n[1]?j(n[1]):null;void 0===this[i]?this[i]=a:(this[i]instanceof Array||(this[i]=[this[i]]),this[i].push(a))}}}
/**
   * Converts QueryString object back to string representation
   *
   * @returns {string}
   */
/**
   * Class Url
   *
   * @param {string} [url] - string URL representation
   * @param {boolean} [noTransform] - do not transform to absolute URL
   * @constructor
   */
function E(t,r){b(this,t,!r)}
/**
   * Clears QueryString, making it contain no params at all
   *
   * @returns {Url}
   */z.prototype.toString=function(){var t,r,e="",o=x;for(t in this){var n=this[t];if(!(n instanceof Function||void 0===n))if(n instanceof Array){var i=n.length;if(!i){
// Parameter is an empty array, so treat as
// an empty argument
e+=(e?"&":"")+o(t)+"=";continue}for(r=0;r<i;r++){var a=n[r];void 0!==a&&(e+=e?"&":"",e+=o(t)+(null===a?"":"="+o(a)))}}// Plain value
else e+=e?"&":"",e+=o(t)+(null===n?"":"="+o(n))}return e},E.prototype.clearQuery=function(){for(var t in this.query)this.query[t]instanceof Function||delete this.query[t];return this},
/**
   * Returns total number of parameters in QueryString
   *
   * @returns {number}
   */
E.prototype.queryLength=function(){var t=0;for(var r in this.query)this.query[r]instanceof Function||t++;return t},
/**
   * Returns true if QueryString contains no parameters, false otherwise
   *
   * @returns {boolean}
   */
E.prototype.isEmptyQuery=function(){return 0===this.queryLength()},
/**
   *
   * @param {Array} [paths] - an array pf path parts (if given will modify
   *                          Url.path property
   * @returns {Array} - an array representation of the Url.path property
   */
E.prototype.paths=function(t){var r,e="",o=0;if(t&&t.length&&t+""!==t){for(this.isAbsolute()&&(e="/"),r=t.length;o<r;o++)t[o]=!o&&v.test(t[o])?t[o]:x(t[o]);this.path=e+t.join("/")}for(o=0,r=(t=("/"===this.path.charAt(0)?this.path.slice(1):this.path).split("/")).length;o<r;o++)t[o]=j(t[o]);return t},
/**
   * Performs URL-specific encoding of the given string
   *
   * @method Url#encode
   * @param {string} s - string to encode
   * @returns {string}
   */
E.prototype.encode=x,
/**
   * Performs URL-specific decoding of the given encoded string
   *
   * @method Url#decode
   * @param {string} s - string to decode
   * @returns {string}
   */
E.prototype.decode=j,
/**
   * Checks if current URL is an absolute resource locator (globally absolute
   * or absolute path to current server)
   *
   * @returns {boolean}
   */
E.prototype.isAbsolute=function(){return this.protocol||"/"===this.path.charAt(0)},
/**
   * Returns string representation of current Url object
   *
   * @returns {string}
   */
E.prototype.toString=function(){return(this.protocol&&this.protocol+"://")+(this.user&&x(this.user)+(this.pass&&":"+x(this.pass))+"@")+(this.host&&this.host)+(this.port&&":"+this.port)+(this.path&&this.path)+(this.query.toString()&&"?"+this.query)+(this.hash&&"#"+x(this.hash))},t[t.exports?"exports":"Url"]=E}("undefined"!=typeof module&&module.exports?module:window);