!function(){"use strict";
/**
   * GoogleMutant by Iván Sánchez Ortega <ivan@sanchezortega.es> https://ivan.sanchezortega.es
   * Source and issue tracking: https://gitlab.com/IvanSanchez/Leaflet.GridLayer.GoogleMutant/
   *
   * Based on techniques from https://github.com/shramov/leaflet-plugins
   * and https://avinmathew.com/leaflet-and-google-maps/ , but relying on MutationObserver.
   *
   * "THE BEER-WARE LICENSE":
   * <ivan@sanchezortega.es> wrote this file. As long as you retain this notice you
   * can do whatever you want with this stuff. If we meet some day, and you think
   * this stuff is worth it, you can buy me a beer in return.
   *
   * Uses MIT-licensed code from https://github.com/rsms/js-lru/
   */
// This implementation of LRUMap is a copy of https://github.com/rsms/js-lru/ ,
// trivially adapted for ES6 exports.
/*
  The MIT License
  	Copyright (c) 2010-2020 Rasmus Andersson <https://rsms.me/>
  	Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:
  	The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.
  	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
  */
/**
   * A doubly linked list-based Least Recently Used (LRU) cache. Will keep most
   * recently used items while discarding least recently used items when its limit
   * is reached.
   *
   * Licensed under MIT. Copyright (c) 2010 Rasmus Andersson <http://hunch.se/>
   * See README.md for details.
   *
   * Illustration of the design:
   *
   *       entry             entry             entry             entry
   *       ______            ______            ______            ______
   *      | head |.newer => |      |.newer => |      |.newer => | tail |
   *      |  A   |          |  B   |          |  C   |          |  D   |
   *      |______| <= older.|______| <= older.|______| <= older.|______|
   *
   *  removed  <--  <--  <--  <--  <--  <--  <--  <--  <--  <--  <--  added
   */var t=Symbol("newer"),e=Symbol("older"),i=function(t,e){"number"!=typeof t&&(
// called as (entries)
e=t,t=0),this.size=0,this.limit=t,this.oldest=this.newest=void 0,this._keymap=new Map,e&&(this.assign(e),t<1&&(this.limit=this.size))};function o(i,o){this.key=i,this.value=o,this[t]=void 0,this[e]=void 0}function n(t){this.entry=t}function s(t){this.entry=t}function a(t){this.entry=t}i.prototype._markEntryAsUsed=function(i){i!==this.newest&&(// HEAD--------------TAIL
//   <.older   .newer>
//  <--- add direction --
//   A  B  C  <D>  E
i[t]&&(i===this.oldest&&(this.oldest=i[t]),i[t][e]=i[e]),i[e]&&(i[e][t]=i[t]),i[t]=void 0,// D --x
i[e]=this.newest,// D. --> E
this.newest&&(this.newest[t]=i),this.newest=i)},i.prototype.assign=function(i){var n,s=this.limit||Number.MAX_VALUE;this._keymap.clear();for(var a=i[Symbol.iterator](),r=a.next();!r.done;r=a.next()){var l=new o(r.value[0],r.value[1]);if(this._keymap.set(l.key,l),n?(n[t]=l,l[e]=n):this.oldest=l,n=l,0==s--)throw new Error("overflow")}this.newest=n,this.size=this._keymap.size},i.prototype.get=function(t){
// First, find our cache entry
var e=this._keymap.get(t);if(e)// Not cached. Sorry.
// As <key> was found in the cache, register it as being requested recently
return this._markEntryAsUsed(e),e.value},i.prototype.set=function(i,n){var s=this._keymap.get(i);return s?(
// update existing
s.value=n,this._markEntryAsUsed(s),this):(// new entry
this._keymap.set(i,s=new o(i,n)),this.newest?(
// link previous tail to the new tail (entry)
this.newest[t]=s,s[e]=this.newest):
// we're first in -- yay
this.oldest=s,// add new entry to the end of the linked list -- it's now the freshest entry.
this.newest=s,++this.size,this.size>this.limit&&
// we hit the limit -- remove the head
this.shift(),this)},i.prototype.shift=function(){
// todo: handle special case when limit == 1
var i=this.oldest;if(i)return this.oldest[t]?(
// advance the list
this.oldest=this.oldest[t],this.oldest[e]=void 0):(
// the cache is exhausted
this.oldest=void 0,this.newest=void 0),// Remove last strong reference to <entry> and remove links from the purged
// entry being returned:
i[t]=i[e]=void 0,this._keymap.delete(i.key),--this.size,[i.key,i.value]},// -------------------------------------------------------------------------------------
// Following code (until end of class definition) is optional and can be removed without
// breaking the core functionality.
i.prototype.find=function(t){var e=this._keymap.get(t);return e?e.value:void 0},i.prototype.has=function(t){return this._keymap.has(t)},i.prototype.delete=function(i){var o=this._keymap.get(i);if(o)return this._keymap.delete(o.key),o[t]&&o[e]?(
// relink the older entry with the newer entry
o[e][t]=o[t],o[t][e]=o[e]):o[t]?(
// remove the link to us
o[t][e]=void 0,// link the newer entry to head
this.oldest=o[t]):o[e]?(
// remove the link to us
o[e][t]=void 0,// link the newer entry to head
this.newest=o[e]):
// if(entry[OLDER] === undefined && entry.newer === undefined) {
this.oldest=this.newest=void 0,this.size--,o.value},i.prototype.clear=function(){
// Not clearing links should be safe, as we don't expose live links to user
this.oldest=this.newest=void 0,this.size=0,this._keymap.clear()},i.prototype.keys=function(){return new s(this.oldest)},i.prototype.values=function(){return new a(this.oldest)},i.prototype.entries=function(){return this},i.prototype[Symbol.iterator]=function(){return new n(this.oldest)},i.prototype.forEach=function(e,i){"object"!=typeof i&&(i=this);for(var o=this.oldest;o;)e.call(i,o.value,o.key,this),o=o[t]},
/** Returns a JSON (array) representation */
i.prototype.toJSON=function(){for(var e=new Array(this.size),i=0,o=this.oldest;o;)e[i++]={key:o.key,value:o.value},o=o[t];return e},
/** Returns a String representation */
i.prototype.toString=function(){for(var e="",i=this.oldest;i;)e+=String(i.key)+":"+i.value,(i=i[t])&&(e+=" < ");return e},n.prototype[Symbol.iterator]=function(){return this},n.prototype.next=function(){var e=this.entry;return e?(this.entry=e[t],{done:!1,value:[e.key,e.value]}):{done:!0,value:void 0}},s.prototype[Symbol.iterator]=function(){return this},s.prototype.next=function(){var e=this.entry;return e?(this.entry=e[t],{done:!1,value:e.key}):{done:!0,value:void 0}},a.prototype[Symbol.iterator]=function(){return this},a.prototype.next=function(){var e=this.entry;return e?(this.entry=e[t],{done:!1,value:e.value}):{done:!0,value:void 0}};// GoogleMutant by Iván Sánchez Ortega <ivan@sanchezortega.es>
var r=new Promise((function(t,e){var i=0,o=null;o=setInterval((function(){return i>=20?(clearInterval(o),e(new Error("window.google not found after 10 seconds"))):window.google&&window.google.maps&&window.google.maps.Map?(clearInterval(o),t(window.google)):void++i}),500)}));// 🍂class GridLayer.GoogleMutant
// 🍂extends GridLayer
L.GridLayer.GoogleMutant=L.GridLayer.extend({options:{minZoom:0,maxZoom:21,
// can be 23, but ugly if more than maxNativeZoom
tileSize:256,subdomains:"abc",errorTileUrl:"",attribution:"",
// The mutant container will add its own attribution anyways.
opacity:1,continuousWorld:!1,noWrap:!1,
// 🍂option type: String = 'roadmap'
// Google's map type. Valid values are 'roadmap', 'satellite' or 'terrain'. 'hybrid' is not really supported.
type:"roadmap",maxNativeZoom:21},initialize:function(t){L.GridLayer.prototype.initialize.call(this,t),this._isMounted=!0,this.once("spawned",(function(){if(this._subLayers)
//restore previously added google layers
for(var t in this._subLayers)this._subLayers[t].setMap(this._mutant)})),// Couple data structures indexed by tile key
this._tileCallbacks={},// Callbacks for promises for tiles that are expected
this._lru=new i(100),// Tile LRU cache
this._imagesPerTile="hybrid"===this.options.type?2:1,this._boundOnMutatedImage=this._onMutatedImage.bind(this)},onAdd:function(t){var e=this;L.GridLayer.prototype.onAdd.call(this,t),this._initMutantContainer(),// Attribution and logo nodes are not mutated a second time if the
// mutant is removed and re-added to the map, hence they are
// not cleaned up on layer removal, so they can be added here.
this._logoContainer&&t._controlCorners.bottomleft.appendChild(this._logoContainer),this._attributionContainer&&t._controlCorners.bottomright.appendChild(this._attributionContainer),r.then((function(){if(e._isMounted&&(e._ready=!0,e._initMutant(),t=e._map)){var i=e.options.updateWhenIdle?"moveend":"move";t.on(i,e._update,e),e.once("remove",(function(){this._map.off(i,this._update,this)})),//handle layer being added to a map for which there are no Google tiles at the given zoom
google.maps.event.addListenerOnce(e._mutant,"idle",(function(){e._map&&(e._checkZoomLevels(),e._mutantIsReady=!0)})),e._update()}}))},onRemove:function(t){L.GridLayer.prototype.onRemove.call(this,t),this._observer.disconnect(),t._container.removeChild(this._mutantContainer),this._logoContainer&&L.DomUtil.remove(this._logoContainer),this._attributionContainer&&L.DomUtil.remove(this._attributionContainer),google.maps.event.clearListeners(t,"idle"),this._mutant&&google.maps.event.clearListeners(this._mutant,"idle"),t.off("move moveend",this._update,this),this._isMounted=!1},
// 🍂method addGoogleLayer(name: String, options?: Object): this
// Adds layer with the given name and options to the google Map instance.
// `name`: one of the google maps API layers, with it's constructor available in `google.maps` object.
// currently following values supported: 'TrafficLayer', 'TransitLayer', 'BicyclingLayer'.
// `options`: see https://developers.google.com/maps/documentation/javascript/reference/map
addGoogleLayer:function(t,e){var i=this;return this._subLayers||(this._subLayers={}),r.then((function(){var o=new(0,google.maps[t])(e);i._mutant&&o.setMap(i._mutant),// otherwise it will be added on 'spawned'
i._subLayers[t]=o})),this},
// 🍂method removeGoogleLayer(name: String): this
// Removes layer with the given name from the google Map instance.
removeGoogleLayer:function(t){var e=this;return r.then((function(){var i=e._subLayers&&e._subLayers[t];i&&(i.setMap(null),delete e._subLayers[t])})),this},_initMutantContainer:function(){this._mutantContainer||(this._mutantContainer=L.DomUtil.create("div","leaflet-google-mutant leaflet-top leaflet-left"),this._mutantContainer.id="_MutantContainer_"+L.Util.stamp(this._mutantContainer),this._mutantContainer.style.zIndex=800,//leaflet map pane at 400, controls at 1000
this._mutantContainer.style.pointerEvents="none",L.DomEvent.off(this._mutantContainer)),this._map.getContainer().appendChild(this._mutantContainer),this.setOpacity(this.options.opacity);var t=this._mutantContainer.style;this.options.zoomSnap<1?(
// Fractional zoom needs a bigger mutant container in order to load more (smaller) tiles
t.width="150%",t.height="150%"):(t.width="100%",t.height="100%"),t.zIndex=-1,this._attachObserver(this._mutantContainer)},_initMutant:function(){var t=this;if(!this._mutant){var e=new google.maps.Map(this._mutantContainer,{center:{lat:0,lng:0},zoom:0,tilt:0,mapTypeId:this.options.type,disableDefaultUI:!0,keyboardShortcuts:!1,draggable:!1,disableDoubleClickZoom:!0,scrollwheel:!1,streetViewControl:!1,styles:this.options.styles||{},backgroundColor:"transparent"});this._mutant=e,google.maps.event.addListenerOnce(e,"idle",(function(){for(var e=t._mutantContainer.querySelectorAll("a"),i=0;i<e.length;++i)e[i].style.pointerEvents="auto"})),// 🍂event spawned
// Fired when the mutant has been created.
this.fire("spawned",{mapObject:e})}},_attachObserver:function(t){this._observer||(this._observer=new MutationObserver(this._onMutations.bind(this))),// pass in the target node, as well as the observer options
this._observer.observe(t,{childList:!0,subtree:!0}),// if we are reusing an old _mutantContainer, we must manually detect
// all existing tiles in it
Array.prototype.forEach.call(t.querySelectorAll("img"),this._boundOnMutatedImage)},_onMutations:function(t){for(var e=0;e<t.length;++e)for(var i=t[e],o=0;o<i.addedNodes.length;++o){var n=i.addedNodes[o];if(n instanceof HTMLImageElement)this._onMutatedImage(n);else if(n instanceof HTMLElement){// Move Google attributions to leaflet's bottom-right control container
if(Array.prototype.forEach.call(n.querySelectorAll("img"),this._boundOnMutatedImage),// Check for, and remove, the "Google Maps can't load correctly" div.
// You *are* loading correctly, you dumbwit.
"white"===n.style.backgroundColor&&L.DomUtil.remove(n),// Check for, and remove, the "For development purposes only" divs on the aerial/hybrid tiles.
0===n.textContent.indexOf("For development purposes only")&&L.DomUtil.remove(n),// Check for, and remove, the "Sorry, we have no imagery here"
// empty <div>s. The [style*="text-align: center"] selector
// avoids matching the attribution notice.
// This empty div doesn't have a reference to the tile
// coordinates, so it's not possible to mark the tile as
// failed.
Array.prototype.forEach.call(n.querySelectorAll('div[draggable=false][style*="text-align: center"]'),L.DomUtil.remove),n.querySelectorAll(".gmnoprint").length>0||n.querySelectorAll('a[title="Click to see this area on Google Maps"]').length>0){var s=this._attributionContainer=L.DomUtil.create("div","leaflet-control leaflet-control-attribution");L.DomEvent.disableClickPropagation(s),s.style.height="14px",this._map._controlCorners.bottomright.appendChild(s),s.appendChild(n)}// Move Google logo to leaflet's bottom-left control container
1e6==n.style.zIndex&&(this._map._controlCorners.bottomleft.appendChild(n),this._logoContainer=n)}}},
// Only images which 'src' attrib match this will be considered for moving around.
// Looks like some kind of string-based protobuf, maybe??
// Only the roads (and terrain, and vector-based stuff) match this pattern
_roadRegexp:/!1i(\d+)!2i(\d+)!3i(\d+)!/,
// On the other hand, raster imagery matches this other pattern
_satRegexp:/x=(\d+)&y=(\d+)&z=(\d+)/,
// On small viewports, when zooming in/out, a static image is requested
// This will not be moved around, just removed from the DOM.
_staticRegExp:/StaticMapService\.GetMapImage/,_onMutatedImage:function(t){var e,i=t.src.match(this._roadRegexp),o=0;if(i?(e={z:i[1],x:i[2],y:i[3]},this._imagesPerTile>1&&(t.style.zIndex=1,o=1)):((i=t.src.match(this._satRegexp))&&(e={x:i[1],y:i[2],z:i[3]}),// imgNode.style.zIndex = 0;
o=0),e){var n=this._tileCoordsToKey(e);t.style.position="absolute",t.style.visibility="hidden";var s=n+"/"+o;// Cache img so it can also be used in subsequent tile requests
this._lru.set(s,t),s in this._tileCallbacks&&this._tileCallbacks[s]&&(
// Use the tile for *all* pending callbacks. They'll be cloned anyway.
this._tileCallbacks[s].forEach((function(e){return e(t)})),delete this._tileCallbacks[s])}else t.src.match(this._staticRegExp)&&(t.style.visibility="hidden")},createTile:function(t,e){var i=this._tileCoordsToKey(t),o=L.DomUtil.create("div");o.style.textAlign="left",o.dataset.pending=this._imagesPerTile,e=e.bind(this,null,o);for(var n=0;n<this._imagesPerTile;++n){var s=i+"/"+n,a=this._lru.get(s);a?(o.appendChild(this._clone(a)),--o.dataset.pending):(this._tileCallbacks[s]=this._tileCallbacks[s]||[],this._tileCallbacks[s].push(function(t
/*, k2*/){return function(i){t.appendChild(this._clone(i)),--t.dataset.pending,parseInt(t.dataset.pending)||e()}.bind(this)}.bind(this)(o
/*, key2*/)))}return parseInt(o.dataset.pending)||L.Util.requestAnimFrame(e),o},_clone:function(t){var e=t.cloneNode(!0);return e.style.visibility="visible",e},_checkZoomLevels:function(){
//setting the zoom level on the Google map may result in a different zoom level than the one requested
//(it won't go beyond the level for which they have data).
var t=this._map.getZoom(),e=this._mutant.getZoom();t&&e&&(e!==t||//zoom levels are out of sync, Google doesn't have data
e>this.options.maxNativeZoom)&&
//at current location, Google does have data (contrary to maxNativeZoom)
//Update maxNativeZoom
this._setMaxNativeZoom(e)},_setMaxNativeZoom:function(t){t!==this.options.maxNativeZoom&&(this.options.maxNativeZoom=t,this._resetView())},_update:function(){
// zoom level check needs to happen before super's implementation (tile addition/creation)
// otherwise tiles may be missed if maxNativeZoom is not yet correctly determined
if(this._mutant){var t=this._map.getCenter(),e=new google.maps.LatLng(t.lat,t.lng),i=Math.round(this._map.getZoom()),o=this._mutant.getZoom();this._mutant.setCenter(e),//ignore fractional zoom levels
i!==o&&(this._mutant.setZoom(i),this._mutantIsReady&&this._checkZoomLevels())}L.GridLayer.prototype._update.call(this)},_resize:function(){var t=this.options.zoomSnap<1?1.5:1,e=this._map.getSize().multiplyBy(t);this._mutantContainer.style.width===e.x&&this._mutantContainer.style.height===e.y||(this.setElementSize(this._mutantContainer,e),this._mutant&&google.maps.event.trigger(this._mutant,"resize"))},_handleZoomAnim:function(){if(this._mutant){var t=this._map.getCenter(),e=new google.maps.LatLng(t.lat,t.lng);this._mutant.setCenter(e),this._mutant.setZoom(Math.round(this._map.getZoom()))}}}),// 🍂factory gridLayer.googleMutant(options)
// Returns a new `GridLayer.GoogleMutant` given its options
L.gridLayer.googleMutant=function(t){return new L.GridLayer.GoogleMutant(t)}}();