<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2014 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Plugin\CMSPlugin;

if (!JLoader::import('components.com_dpcalendar.helpers.dpcalendar', JPATH_ADMINISTRATOR)) {
	return;
}

class PlgSearchDPCalendar extends CMSPlugin
{
	public function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();
	}

	public function onContentSearchAreas()
	{
		static $areas = ['dpcalendar' => 'PLG_SEARCH_DPCALENDAR_EVENTS'];

		return $areas;
	}

	public function onContentSearch($text, $phrase = '', $ordering = '', $areas = null)
	{
		$searchText = $text;
		if (is_array($areas)) {
			if (!array_intersect($areas, array_keys($this->onContentSearchAreas()))) {
				return [];
			}
		}

		$text = trim($text);
		if ($text == '') {
			return [];
		}

		Factory::getLanguage()->load('com_dpcalendar', JPATH_ADMINISTRATOR . '/components/com_dpcalendar');
		JLoader::import('joomla.application.component.model');
		BaseDatabaseModel::addIncludePath(JPATH_SITE . '/components/com_dpcalendar/models', 'DPCalendarModel');

		$model = BaseDatabaseModel::getInstance('Events', 'DPCalendarModel', ['ignore_request' => true]);
		$model->getState();
		$model->setState('list.limit', $this->params->get('search_limit', 50));
		$model->setState('category.id', 'root');
		$model->setState('category.recursive', true);
		$model->setState('filter.ongoing', 1);
		$model->setState('filter.expand', true);
		$model->setState('filter.author', $this->params->get('show_my_only', 0) == '1' ? '-1' : '0');

		if ($this->params->get('pastevents', 1)) {
			$model->setState('list.start-date', 0);
		} else {
			$model->setState('list.start-date', DPCalendarHelper::getDate()->format('U'));
		}
		$model->setState('list.end-date', null);

		$state = [];
		if ($this->params->get('search_content', 1)) {
			$state[] = 1;
		}
		if ($this->params->get('search_archived', 1)) {
			$state[] = 2;
		}

		if (empty($state)) {
			return [];
		}

		$model->setState('filter.state', $state);

		switch ($ordering) {
			case 'oldest':
				$model->setState('list.ordering', 'a.start_date');
				$model->setState('list.direction', 'asc');
				break;
			case 'popular':
				$model->setState('list.ordering', 'a.hits');
				$model->setState('list.direction', 'desc');
				break;
			case 'alpha':
				$model->setState('list.ordering', 'a.title');
				$model->setState('list.direction', 'asc');
				break;
			case 'category':
				$model->setState('list.ordering', 'c.title');
				$model->setState('list.direction', 'asc');
				break;
			case 'newest':
			default:
				$model->setState('list.ordering', 'a.start_date');
				$model->setState('list.direction', 'desc');
				break;
		}

		$model->setState('filter.search', $text);

		$events = $model->getItems();

		foreach ($events as $key => $item) {
			$events[$key]->section    = DPCalendarHelper::getCalendar($item->catid)->title;
			$events[$key]->browsernav = $item->title;
			$events[$key]->href       = DPCalendarHelperRoute::getEventRoute($item->id, $item->catid);

			$events[$key]->text = $item->title . '<br/>' . Text::_('COM_DPCALENDAR_DATE') . ' ' .
				DPCalendarHelper::getDateStringFromEvent($item, $this->params->get('date_format'), $this->params->get('time_format'));
		}

		return $events;
	}
}
