<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2014 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Module\Counter\Site\Dispatcher;

defined('_JEXEC') or die();

use DigitalPeak\Component\DPCalendar\Administrator\Helper\DateHelper;
use DigitalPeak\Component\DPCalendar\Administrator\Helper\DPCalendarHelper;
use DigitalPeak\Component\DPCalendar\Administrator\HTML\Document\HtmlDocument;
use DigitalPeak\Component\DPCalendar\Administrator\Router\Router;
use DigitalPeak\Component\DPCalendar\Administrator\Translator\Translator;
use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Registry\Registry;

class Dispatcher extends AbstractModuleDispatcher
{
	protected function getLayoutData()
	{
		$data = parent::getLayoutData();
		if ($data === false) {
			return $data;
		}

		$app = $data['app'];
		if (!$app instanceof CMSWebApplicationInterface) {
			return $data;
		}

		/** @var Registry $params */
		$params = $data['params'];

		// Helpers
		$document   = new HtmlDocument();
		$translator = new Translator();
		$dateHelper = new DateHelper();
		$dateHelper->setTranslator($translator);

		$layoutHelper = $app->bootComponent('dpcalendar')->getMVCFactory()->createModel('Layout', 'Administrator');
		$router       = new Router();

		$cParams      = clone ComponentHelper::getParams('com_dpcalendar');
		$moduleParams = $cParams->merge($params);

		// The display data
		$data = array_merge($data, [
			'document'     => $document,
			'layoutHelper' => $layoutHelper,
			'dateHelper'   => $dateHelper,
			'translator'   => $translator,
			'router'       => $router,
			'input'        => $app->getInput(),
			'params'       => $moduleParams
		]);

		$app->getLanguage()->load('com_dpcalendar', JPATH_ADMINISTRATOR . '/components/com_dpcalendar');
		$app->getLanguage()->load('com_dpcalendar', JPATH_SITE . '/components/com_dpcalendar');

		$model = $app->bootComponent('dpcalendar')->getMVCFactory()->createModel('Calendar', 'Site', ['ignore_request' => true]);
		$model->getState();
		$model->setState('filter.parentIds', $moduleParams->get('ids', ['root']));

		$ids = [];
		foreach ($model->getItems() as $calendar) {
			$ids[] = $calendar->getId();
		}

		if ($ids === []) {
			return $data;
		}

		$startDate = trim((string)$params->get('start_date', ''));
		if ($startDate === 'start of day') {
			$startDate = $dateHelper->getDate(null, true, 'UTC');
			$startDate->setTime(0, 0, 0);
		} else {
			$startDate = $dateHelper->getDate($startDate);
		}

		// Round to the last quater
		$startDate->sub(new \DateInterval("PT" . $startDate->format("s") . "S"));
		$startDate->sub(new \DateInterval("PT" . ($startDate->format("i") % 15) . "M"));

		$endDate = clone $startDate;
		$endDate->modify('+1 year');

		$model = $app->bootComponent('dpcalendar')->getMVCFactory()->createModel('Events', 'Site', ['ignore_request' => true]);
		$model->getState();
		$model->setState('list.limit', $params->get('max_events', 1));
		$model->setState('list.direction', $params->get('order', 'asc'));
		$model->setState('category.id', $ids);
		$model->setState('category.recursive', true);
		$model->setState('filter.search', $params->get('filter', ''));
		$model->setState('filter.expand', true);
		$model->setState('filter.state', 1);
		$model->setState('filter.language', $app->getLanguage()->getTag());
		$model->setState('filter.publish_date', true);
		$model->setState('list.start-date', $startDate);
		$model->setState('list.end-date', $endDate);
		$model->setState('filter.tags', $params->get('filter_tags', []));
		$model->setState('filter.locations', $params->get('filter_locations', []));
		$model->setState('filter.author', $params->get('filter_author', 0));

		$events = $model->getItems();
		foreach ($events as $event) {
			$event->truncatedDescription = $event->introText ?: '';
			if (!$event->introText && ($params->get('description_length') > 0 || $params->get('description_length') === null)) {
				$event->truncatedDescription = HTMLHelper::_('string.truncate', $event->description ?: '', $params->get('description_length'));
				$event->truncatedDescription = HTMLHelper::_('content.prepare', $event->truncatedDescription);
				$event->truncatedDescription = DPCalendarHelper::fixImageLinks($event->truncatedDescription);
			}
		}

		$data['events']      = $events;
		$data['displayData'] = $data;

		return $data;
	}
}
