<?php
/**
 * @package   DPCalendar
 * @copyright Copyright (C) 2014 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Module\Map\Site\Dispatcher;

defined('_JEXEC') or die();

use DigitalPeak\Component\DPCalendar\Administrator\Helper\DateHelper;
use DigitalPeak\Component\DPCalendar\Administrator\HTML\Document\HtmlDocument;
use DigitalPeak\Component\DPCalendar\Administrator\Router\Router;
use DigitalPeak\Component\DPCalendar\Administrator\Translator\Translator;
use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\Registry\Registry;

class Dispatcher extends AbstractModuleDispatcher
{
	protected function getLayoutData()
	{
		$data = parent::getLayoutData();
		if ($data === false) {
			return $data;
		}

		$app = $data['app'];
		if (!$app instanceof CMSWebApplicationInterface) {
			return $data;
		}

		/** @var Registry $params */
		$params = $data['params'];

		// Helpers
		$document   = new HtmlDocument();
		$translator = new Translator();
		$dateHelper = new DateHelper();
		$dateHelper->setTranslator($translator);

		$layoutHelper = $app->bootComponent('dpcalendar')->getMVCFactory()->createModel('Layout', 'Administrator');
		$router       = new Router();

		$cParams      = clone ComponentHelper::getParams('com_dpcalendar');
		$moduleParams = $cParams->merge($params);

		// The display data
		$data = array_merge($data, [
			'document'     => $document,
			'layoutHelper' => $layoutHelper,
			'dateHelper'   => $dateHelper,
			'translator'   => $translator,
			'router'       => $router,
			'input'        => $app->getInput(),
			'params'       => $moduleParams,
			'format'       => $params->get('date_format', 'd.m.Y')
		]);

		$app->getLanguage()->load('com_dpcalendar', JPATH_ADMINISTRATOR . '/components/com_dpcalendar');
		$app->getLanguage()->load('com_dpcalendar', JPATH_SITE . '/components/com_dpcalendar');

		$app->getLanguage()->load('com_dpcalendar', JPATH_ADMINISTRATOR . '/components/com_dpcalendar');

		$state = new Registry();

		$context = 'com_dpcalendar.map.';

		$state->set('filter.search', $app->getUserStateFromRequest($context . 'search', 'search'));
		$state->set('filter.location', $app->getUserStateFromRequest($context . 'location', 'location'));
		$state->set('filter.radius', $app->getUserStateFromRequest($context . 'radius', 'radius', $params->get('radius', 20)));
		$state->set('filter.length-type', $app->getUserStateFromRequest($context . 'length-type', 'length-type', $params->get('length_type', 'm')));

		$startDate = $app->getUserStateFromRequest($context . 'start-date', 'start-date');
		if (!$startDate) {
			$startDate = $params->get('start_date');
		}
		if ($startDate) {
			$startDate = $dateHelper->getDate($startDate, true);
		}

		$endDate = $app->getUserStateFromRequest($context . 'end-date', 'end-date');
		if (!$endDate) {
			$endDate = $params->get('end_date');
		}
		if ($endDate) {
			$endDate = $dateHelper->getDate($endDate, true);
		}

		$data['startDate']   = $startDate;
		$data['endDate']     = $endDate;
		$data['state']       = $state;
		$data['displayData'] = $data;

		return $data;
	}
}
