<?php
/**
 * @package   DPMedia
 * @copyright Copyright (C) 2021 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Plugin\Filesystem\DPFtp\Extension;

use DigitalPeak\Library\DPMedia\Extension\Media;
use DigitalPeak\Plugin\Filesystem\DPFtp\Client\ClientAwareInterface;
use DigitalPeak\Plugin\Filesystem\DPFtp\Client\ClientAwareTrait;

class Ftp extends Media implements ClientAwareInterface
{
	use ClientAwareTrait;

	public function getAdapters(): array
	{
		$adapters = parent::getAdapters();
		foreach ($adapters as $adapter) {
			$adapter->setClient($this->getClient());
		}

		return $adapters;
	}
}
