<?php
/**
 * @package   DPMedia
 * @copyright Copyright (C) 2021 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Plugin\Filesystem\DPFtp\Adapter;

use DigitalPeak\Library\DPMedia\Adapter\CacheFactoryAwareInterface;
use DigitalPeak\Library\DPMedia\Adapter\CacheTrait;
use DigitalPeak\Library\DPMedia\Adapter\StreamSupportTrait;

/**
 * Read and write FTP adapter for Joomla 4 media manager.
 */
class FtpAdapterWritable extends FtpAdapter implements CacheFactoryAwareInterface
{
	use CacheTrait;
	use StreamSupportTrait;

	public function getResource(string $path): mixed
	{
		$this->getClient()->connect($this->getConfig());

		$handle = fopen('php://temp', 'w+');
		if ($handle === false) {
			throw new \Exception('Could not open tmp file!');
		}

		fwrite($handle, $this->getClient()->download($this->getPath($path)));
		rewind($handle);
		return $handle;
	}

	public function createFolder(string $name, string $path): string
	{
		$this->getClient()->connect($this->getConfig());
		$newPath = $this->getClient()->mkdir($this->getPath($path) . '/' . $name);

		$this->clearCache($path);

		return basename($newPath);
	}

	public function createFile(string $name, string $path, $data): string
	{
		$this->updateFile($name, $path, $data);

		$this->clearCache($path);

		return $name;
	}

	public function updateFile(string $name, string $path, $data): void
	{
		$this->getClient()->connect($this->getConfig());
		$this->getClient()->upload($this->getPath($path) . '/' . $name, $data);

		$this->clearCache($path . '/' . $name);
		$this->deleteThumb($path . '/' . $name, $this->getConfig());
	}

	public function delete(string $path): void
	{
		$this->getClient()->connect($this->getConfig());
		$this->getClient()->delete($this->getPath($path));

		$this->clearCache($path);
		$this->deleteThumb($path, $this->getConfig());
	}

	public function move(string $sourcePath, string $destinationPath, bool $force = false): string
	{
		$this->getClient()->connect($this->getConfig());
		$this->getClient()->rename($this->getPath($sourcePath), $this->getPath($destinationPath));

		$this->clearCache($sourcePath);
		$this->deleteThumb($sourcePath, $this->getConfig());

		return $destinationPath;
	}

	public function copy(string $sourcePath, string $destinationPath, bool $force = false): string
	{
		throw new \Exception('Not possible on FTP!');
	}
}
