<?php
/**
 * @package   DPMedia
 * @copyright Copyright (C) 2021 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Plugin\Filesystem\Ftp\Client;

/**
 * FTP client aware trait.
 */
trait ClientAwareTrait
{
	/** @var Client $client */
	private $client;

	/**
	 * Get the client.
	 */
	public function getClient(): Client
	{
		return $this->client;
	}

	/**
	 * Set the client.
	 */
	public function setClient(Client $client): void
	{
		$this->client = $client;
	}
}
