<?php
/**
 * @package   DPMedia
 * @copyright Copyright (C) 2021 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

use DigitalPeak\Library\DPMedia\Service\MediaProvider;
use DigitalPeak\Plugin\Filesystem\Ftp\Client\Client;
use DigitalPeak\Plugin\Filesystem\Ftp\Extension\Ftp;
use Joomla\CMS\Extension\PluginInterface;
use Joomla\DI\Container;

require_once JPATH_PLUGINS . '/filesystem/dpftp/vendor/autoload.php';

return new class () extends MediaProvider {
	public function __construct()
	{
		parent::__construct(Ftp::class);
	}

	public function register(Container $container): void
	{
		parent::register($container);

		$container->set(Client::class, static fn (): Client => new Client());

		$container->extend(
			PluginInterface::class,
			static function (Ftp $extension, Container $container): Ftp {
				$extension->setClient($container->get(Client::class));
				return $extension;
			}
		);
	}
};
