<?php
/**
 * @package   DPMedia
 * @copyright Copyright (C) 2022 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Module\DPMedia\Gallery\Site\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Component\Media\Administrator\Provider\ProviderManagerHelperTrait;
use Joomla\Registry\Registry;

class DpmediaGalleryHelper
{
	use ProviderManagerHelperTrait;

	public function getFilesAjax(): array
	{
		$app    = Factory::getApplication();
		$module = ModuleHelper::getModuleById($app->getInput()->get('id', '0'));

		$files = [];
		foreach ((new Registry($module->params))->get('folders', []) as $folder) {
			['adapter' => $adapter,'path' => $path] = $this->resolveAdapterAndPath($folder->folder);
			$adapter                                = $this->getAdapter($adapter);

			foreach ($adapter->getFiles($path) as $file) {
				if (empty($file->url)) {
					$file->url = $adapter->getUrl($file->path);
				}

				$files[] = $file;
			}
		}

		return \array_slice($files, $app->getInput()->getInt('start', 0), $app->getInput()->getInt('limit', 20));
	}
}
