<?php
/**
 * @package   DPMedia
 * @copyright Copyright (C) 2022 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\Registry\Registry;

\defined('_JEXEC') or die();

/**
 * @var Registry $params
 * @var stdClass $module
 * @var CMSWebApplicationInterface $app
 */

$app->getDocument()->getWebAssetManager()->registerAndUseScript('mod_dpmedia_gallery', 'mod_dpmedia_gallery/masonry.min.js',[],['defer' => true, 'type' => 'module']);
$app->getDocument()->getWebAssetManager()->registerAndUseStyle('mod_dpmedia_gallery', 'mod_dpmedia_gallery/masonry.min.css');
if ($content = $params->get('custom_css', '')) {
	$app->getDocument()->getWebAssetManager()->addInlineStyle($content);
}
?>
<div class="mod-dpmedia-gallery-masonry mod-dpmedia-gallery mod-dpmedia-gallery-<?php echo $module->id; ?>"
	data-id="<?php echo $module->id; ?>" data-column-width="250">
	<div class="mod-dpmedia-gallery__container"></div>
	<div class="mod-dpmedia-gallery__footer"></div>
	<template class="mod-dpmedia-gallery__item-template">
		<div class="mod-dpmedia-gallery__item dp-media-item">
			<a class="dp-media-item__link"><img class="dp-media-item__image"/></a>
			<div class="dp-media-item__caption"></div>
		</div>
	</template>
</div>
