<?php
/**
 * @package   DPMedia
 * @copyright Copyright (C) 2022 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\Registry\Registry;

\defined('_JEXEC') or die();

/**
 * @var Registry $params
 * @var stdClass $module
 * @var CMSWebApplicationInterface $app
 */

$app->getDocument()->getWebAssetManager()->registerAndUseScript('mod_dpmedia_gallery', 'mod_dpmedia_gallery/slider.min.js',[],['defer' => true, 'type' => 'module']);
$app->getDocument()->getWebAssetManager()->registerAndUseStyle('mod_dpmedia_gallery', 'mod_dpmedia_gallery/slider.min.css');
if ($content = $params->get('custom_css', '')) {
	$app->getDocument()->getWebAssetManager()->addInlineStyle($content);
}
?>
<div class="mod-dpmedia-gallery-slider mod-dpmedia-gallery mod-dpmedia-gallery-<?php echo $module->id; ?>" data-id="<?php echo $module->id; ?>">
	<div class="mod-dpmedia-gallery-slider__track" data-glide-el="track">
		<div class="mod-dpmedia-gallery-slider__container mod-dpmedia-gallery-slider__slides"></div>
	</div>
	<div class="mod-dpmedia-gallery-slider__arrows" data-glide-el="controls">
		<button class="mod-dpmedia-gallery-slider__arrow mod-dpmedia-gallery-slider__arrow--left" data-glide-dir="<">&lt;</button>
		<button class="mod-dpmedia-gallery-slider__arrow mod-dpmedia-gallery-slider__arrow--right" data-glide-dir=">">&gt;</button>
	</div>
	<template class="mod-dpmedia-gallery__item-template">
		<div class="mod-dpmedia-gallery__item mod-dpmedia-gallery-slider__slide dp-media-item">
			<img class="dp-media-item__image"/>
			<div class="dp-media-item__caption"></div>
		</div>
	</template>
</div>
