<?php
/**
 * @package   DPMedia
 * @copyright Copyright (C) 2021 Digital Peak GmbH. <https://www.digital-peak.com>
 * @license   https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */

namespace DigitalPeak\Plugin\MediaAction\Emoji\Field;

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;

class DpemojipresetsField extends ListField
{
	protected $type = 'Dpemojipresets';

	protected function getOptions(): array
	{
		$plugin = PluginHelper::getPlugin('media-action', 'dpemoji');

		$params = new Registry($plugin->params);

		$options = [(object)['text' => '', 'value' => '']];
		foreach ($params->get('presets', []) as $preset) {
			$options[] = (object)['text' => $preset->title, 'value' => json_encode($preset)];
		}
		return $options;
	}
}
